<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Welcome extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/userguide3/general/urls.html
	 */
	function __construct()
	{
		parent::__construct();
		$this->load->library('session');
		$this->is_logged_in();
		$this->load->model('mainmodel');
		$this->db->query('SET SESSION sql_mode =
                  REPLACE(REPLACE(REPLACE(
                  @@sql_mode,
                  "ONLY_FULL_GROUP_BY,", ""),
                  ",ONLY_FULL_GROUP_BY", ""),
                  "ONLY_FULL_GROUP_BY", "")');
		date_default_timezone_set("Asia/Kolkata");
	}


	public function index()
	{
		$this->load->view('includes/admin_header');
		$this->load->view('list_schools');
		$this->load->view('includes/footer');
	}
	public function is_logged_in()
	{
		$is_logged_in = $this->session->userdata('is_logged_in');
		$role = $this->session->userdata('role');
		if(!isset($is_logged_in) || $is_logged_in != true )
		{
			//|| $role != "superadmin"
			redirect('/', 'refresh');
		}
	}
	
	function is_logged_out()
    {
        $this->session->unset_userdata('is_logged_in');
        redirect('/', 'refresh');
	}
	public function dashboard()
	{
	    $data['users'] = $this->mainmodel->common_fetch('users',array('delete_status' => 1));
	    $data['zones'] = $this->mainmodel->common_fetch('zones',array('delete_status' => 1));
	    $data['payments'] = $this->mainmodel->get_total_payments_count();
	    $this->load->view('includes/admin_header');
		$this->load->view('admin/dashboard',$data);
		$this->load->view('includes/footer');
	}
	
	
	
	  // Create a new zone
    // Get all zones with their boundaries
    public function get_zones() {
        $zones = $this->Zone_model->get_all_zones_with_boundaries();
        echo json_encode($zones);
    }

    // Update zone by ID
    public function update($id) {
        $json = file_get_contents('php://input');
        $data = json_decode($json, true);

        $zone_name = $data['zone_name'] ?? '';
        $boundaries = $data['boundaries'] ?? [];

        if ($zone_name && !empty($boundaries)) {
            $this->Zone_model->update_zone($id, $zone_name, $boundaries);
            echo json_encode(['status' => true, 'message' => 'Zone updated']);
        } else {
            echo json_encode(['status' => false, 'message' => 'Missing zone name or boundaries']);
        }
    }

    // Delete zone by ID
    public function delete($id) {
        $this->Zone_model->delete_zone($id);
        echo json_encode(['status' => true, 'message' => 'Zone deleted']);
    }

    // Check if a location is inside any zone
    public function check_location() {
        $json = file_get_contents('php://input');
        $data = json_decode($json, true);

        $lat = $data['latitude'] ?? null;
        $lng = $data['longitude'] ?? null;

        if ($lat && $lng) {
            $zone = $this->Zone_model->is_point_in_zone($lat, $lng);
            if ($zone) {
                echo json_encode(['zone' => $zone->name]);
            } else {
                echo json_encode(['zone' => null]);
            }
        } else {
            echo json_encode(['zone' => null, 'message' => 'Invalid coordinates']);
        }
    }

	
	
	
	
	
/* activity module*/	
	public function list_activities()
	{
	    $this->load->view('includes/admin_header');
		$this->load->view('admin/list_activities');
		$this->load->view('includes/footer');
	}
	public function all_activities_info()
	{
	    $categories = $this->mainmodel->get_all_activity_details($_POST);
        $result_count=$this->mainmodel->get_all_activity_details($_POST,1); 
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}
	
	public function add_new_activity() {
        $user_type = $this->input->post('user_type');
        $activity_name = $this->input->post('activity_name');

        // Simple validation
        if(!empty($user_type) && !empty($activity_name)) {
            // You can insert into database here...
            $data = array(
                'user_type' => $user_type,
                'activity_name' => $activity_name,
                'created_on' => date('Y-m-d H:i:s')
                );
                $insert = $this->mainmodel->common_insert('activities',$data);

            echo json_encode([
                'status' => 'success',
                'message' => 'Form submitted successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }
    public function fetch_activity_data()
    {
        $id = $this->input->post('id');
        $fetch = $this->mainmodel->common_fetch('activities',array('id' => $id));
         echo json_encode([
                'status' => 'success',
                'message' => 'Data Fetched Successfully..!',
                'details' => $fetch
            ]);
    }
    public function delete_activity()
    {
        $id = $this->input->post('id');
        $fetch = $this->mainmodel->common_update('activities',array('delete_status' => 0,'updated_on' => date('Y-m-d H:i:s')),array('id' => $id));
        //echo $this->db->last_query();exit;
         echo json_encode([
                'status' => 'success',
                'message' => 'Data Deleted Successfully..!'
            ]);
    }
    public function update_activity()
    {
         $activity_id = $this->input->post('activity_id');
         $user_type = $this->input->post('user_type');
        $activity_name = $this->input->post('activity_name');

        // Simple validation
        if(!empty($user_type) && !empty($activity_name) && !empty($activity_id)) {
            // You can insert into database here...
            $data = array(
                'user_type' => $user_type,
                'activity_name' => $activity_name,
                'updated_on' => date('Y-m-d H:i:s')
                );
                $update = $this->mainmodel->common_update('activities',$data,array('id' => $activity_id));

            echo json_encode([
                'status' => 'success',
                'message' => 'Activity Details Updated successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }

/* interest module*/	
	public function list_interests()
	{
	    $this->load->view('includes/admin_header');
		$this->load->view('admin/list_interests');
		$this->load->view('includes/footer'); 
	}
	public function all_interests_info()
	{
	    $categories = $this->mainmodel->get_all_interest_details($_POST);
        $result_count=$this->mainmodel->get_all_interest_details($_POST,1); 
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}
	
	public function add_new_interest()
	{
        $user_type = $this->input->post('user_type');
        $interest_name = $this->input->post('interest_name');

        // Simple validation
        if(!empty($user_type) && !empty($interest_name)) {
            // You can insert into database here...
            $data = array(
                'user_type' => $user_type,
                'interest_name' => $interest_name,
                'created_on' => date('Y-m-d H:i:s')
                );
                $insert = $this->mainmodel->common_insert('interests',$data);

            echo json_encode([
                'status' => 'success',
                'message' => 'Form submitted successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }
    public function fetch_interest_data()
    {
        $id = $this->input->post('id');
        $fetch = $this->mainmodel->common_fetch('interests',array('id' => $id));
         echo json_encode([
                'status' => 'success',
                'message' => 'Data Fetched Successfully..!',
                'details' => $fetch
            ]);
    }
    public function delete_interest()
    {
        $id = $this->input->post('id');
        $fetch = $this->mainmodel->common_update('interests',array('delete_status' => 0,'updated_on' => date('Y-m-d H:i:s')),array('id' => $id));
        //echo $this->db->last_query();exit;
         echo json_encode([
                'status' => 'success',
                'message' => 'Data Deleted Successfully..!'
            ]);
    }
    public function update_interest()
    {
         $interest_id = $this->input->post('interest_id');
         $user_type = $this->input->post('user_type');
        $interest_name = $this->input->post('interest_name');

        // Simple validation
        if(!empty($user_type) && !empty($interest_name) && !empty($interest_id)) {
            // You can insert into database here...
            $data = array(
                'user_type' => $user_type,
                'interest_name' => $interest_name,
                'updated_on' => date('Y-m-d H:i:s')
                );
                $update = $this->mainmodel->common_update('interests',$data,array('id' => $interest_id));

            echo json_encode([
                'status' => 'success',
                'message' => 'Interest Details Updated successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }
	
/* looking for module*/	
	public function list_looking_fors()
	{
	    $this->load->view('includes/admin_header');
		$this->load->view('admin/list_looking_fors');
		$this->load->view('includes/footer'); 
	}
	public function all_looking_fors_info()
	{
	    $categories = $this->mainmodel->get_all_looking_for_details($_POST);
        $result_count=$this->mainmodel->get_all_looking_for_details($_POST,1); 
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}
	
	public function add_new_looking_for()
	{
        $user_type = $this->input->post('user_type');
        $looking_for_name = $this->input->post('looking_for_name');

        // Simple validation
        if(!empty($user_type) && !empty($looking_for_name)) {
            // You can insert into database here...
            $data = array(
                'user_type' => $user_type,
                'looking_for_name' => $looking_for_name,
                'created_on' => date('Y-m-d H:i:s')
                );
                $insert = $this->mainmodel->common_insert('looking_for',$data);

            echo json_encode([
                'status' => 'success',
                'message' => 'Form submitted successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }
    public function fetch_looking_for_data()
    {
        $id = $this->input->post('id');
        $fetch = $this->mainmodel->common_fetch('looking_for',array('id' => $id));
         echo json_encode([
                'status' => 'success',
                'message' => 'Data Fetched Successfully..!',
                'details' => $fetch
            ]);
    }
    public function delete_looking_for()
    {
        $id = $this->input->post('id');
        $fetch = $this->mainmodel->common_update('looking_for',array('delete_status' => 0,'updated_on' => date('Y-m-d H:i:s')),array('id' => $id));
        //echo $this->db->last_query();exit;
         echo json_encode([
                'status' => 'success',
                'message' => 'Data Deleted Successfully..!'
            ]);
    }
    public function update_looking_for()
    {
         $looking_for_id = $this->input->post('looking_for_id');
         $user_type = $this->input->post('user_type');
        $looking_for_name = $this->input->post('looking_for_name');

        // Simple validation
        if(!empty($user_type) && !empty($looking_for_name) && !empty($looking_for_id)) {
            // You can insert into database here...
            $data = array(
                'user_type' => $user_type,
                'looking_for_name' => $looking_for_name,
                'updated_on' => date('Y-m-d H:i:s')
                );
                $update = $this->mainmodel->common_update('looking_for',$data,array('id' => $looking_for_id));

            echo json_encode([
                'status' => 'success',
                'message' => 'Interest Details Updated successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }

/* interest module*/	
	public function list_personality_traits()
	{
	    $this->load->view('includes/admin_header');
		$this->load->view('admin/list_personality_traits');
		$this->load->view('includes/footer'); 
	}
	public function all_personality_traits_info()
	{
	    $categories = $this->mainmodel->get_all_personality_traits_details($_POST);
        $result_count=$this->mainmodel->get_all_personality_traits_details($_POST,1); 
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}
	
	public function add_new_personality_traits()
	{
        $user_type = $this->input->post('user_type');
        $personality_traits_name = $this->input->post('personality_traits_name');

        // Simple validation
        if(!empty($user_type) && !empty($personality_traits_name)) {
            // You can insert into database here...
            $data = array(
                'user_type' => $user_type,
                'personality_traits_name' => $personality_traits_name,
                'created_on' => date('Y-m-d H:i:s')
                );
                $insert = $this->mainmodel->common_insert('personality_traits',$data);

            echo json_encode([
                'status' => 'success',
                'message' => 'Form submitted successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }
    public function fetch_personality_traits_data()
    {
        $id = $this->input->post('id');
        $fetch = $this->mainmodel->common_fetch('personality_traits',array('id' => $id));
         echo json_encode([
                'status' => 'success',
                'message' => 'Data Fetched Successfully..!',
                'details' => $fetch
            ]);
    }
    public function delete_personality_traits()
    {
        $id = $this->input->post('id');
        $fetch = $this->mainmodel->common_update('personality_traits',array('delete_status' => 0,'updated_on' => date('Y-m-d H:i:s')),array('id' => $id));
        //echo $this->db->last_query();exit;
         echo json_encode([
                'status' => 'success',
                'message' => 'Data Deleted Successfully..!'
            ]);
    }
    public function update_personality_traits()
    {
         $personality_traits_id = $this->input->post('personality_traits_id');
         $user_type = $this->input->post('user_type');
        $personality_traits_name = $this->input->post('personality_traits_name');

        // Simple validation
        if(!empty($user_type) && !empty($personality_traits_name) && !empty($personality_traits_id)) {
            // You can insert into database here...
            $data = array(
                'user_type' => $user_type,
                'personality_traits_name' => $personality_traits_name,
                'updated_on' => date('Y-m-d H:i:s')
                );
                $update = $this->mainmodel->common_update('personality_traits',$data,array('id' => $personality_traits_id));

            echo json_encode([
                'status' => 'success',
                'message' => 'Interest Details Updated successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }
/* interest module*/	
	public function list_preferences()
	{
	    $this->load->view('includes/admin_header');
		$this->load->view('admin/list_preferences');
		$this->load->view('includes/footer'); 
	}
	public function all_preferences_info()
	{
	    $categories = $this->mainmodel->get_all_preferences_details($_POST);
        $result_count=$this->mainmodel->get_all_preferences_details($_POST,1); 
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}
	
	public function add_new_preferences()
	{
        $user_type = $this->input->post('user_type');
        $preference_name = $this->input->post('preference_name');

        // Simple validation
        if(!empty($user_type) && !empty($preference_name)) {
            // You can insert into database here...
            $data = array(
                'user_type' => $user_type,
                'preference_name' => $preference_name,
                'created_on' => date('Y-m-d H:i:s')
                );
                $insert = $this->mainmodel->common_insert('preferences',$data);

            echo json_encode([
                'status' => 'success',
                'message' => 'Form submitted successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }
    public function fetch_preferences_data()
    {
        $id = $this->input->post('id');
        $fetch = $this->mainmodel->common_fetch('preferences',array('id' => $id));
         echo json_encode([
                'status' => 'success',
                'message' => 'Data Fetched Successfully..!',
                'details' => $fetch
            ]);
    }
    public function delete_preferences()
    {
        $id = $this->input->post('id');
        $fetch = $this->mainmodel->common_update('preferences',array('delete_status' => 0,'updated_on' => date('Y-m-d H:i:s')),array('id' => $id));
        //echo $this->db->last_query();exit;
         echo json_encode([
                'status' => 'success',
                'message' => 'Data Deleted Successfully..!'
            ]);
    }
    public function update_preferences()
    {
         $preference_id = $this->input->post('preference_id');
         $user_type = $this->input->post('user_type');
        $preference_name = $this->input->post('preference_name');

        // Simple validation
        if(!empty($user_type) && !empty($preference_name) && !empty($preference_id)) {
            // You can insert into database here...
            $data = array(
                'user_type' => $user_type,
                'preference_name' => $preference_name,
                'updated_on' => date('Y-m-d H:i:s')
                );
                $update = $this->mainmodel->common_update('preferences',$data,array('id' => $preference_id));

            echo json_encode([
                'status' => 'success',
                'message' => 'Interest Details Updated successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }

/* achievements module*/	
	public function list_achievements()
	{
	    $this->load->view('includes/admin_header');
		$this->load->view('admin/list_achievements');
		$this->load->view('includes/footer'); 
	}
	public function all_achievements_info()
	{
	    $categories = $this->mainmodel->get_all_achievements_details($_POST);
        $result_count=$this->mainmodel->get_all_achievements_details($_POST,1); 
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}
	
	public function add_new_achievements()
	{
        //$user_type = $this->input->post('user_type');
        $achievement_name = $this->input->post('achievement_name');

        // Simple validation
        if(!empty($achievement_name)) {
            // You can insert into database here...
            $data = array(
               // 'user_type' => $user_type,
                'achievement_name' => $achievement_name,
                'created_on' => date('Y-m-d H:i:s')
                );
                $insert = $this->mainmodel->common_insert('achievements',$data);

            echo json_encode([
                'status' => 'success',
                'message' => 'Form submitted successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }
    public function fetch_achievements_data()
    {
        $id = $this->input->post('id');
        $fetch = $this->mainmodel->common_fetch('achievements',array('id' => $id));
         echo json_encode([
                'status' => 'success',
                'message' => 'Data Fetched Successfully..!',
                'details' => $fetch
            ]);
    }
    public function delete_achievements()
    {
        $id = $this->input->post('id');
        $fetch = $this->mainmodel->common_update('achievements',array('delete_status' => 0,'updated_on' => date('Y-m-d H:i:s')),array('id' => $id));
        //echo $this->db->last_query();exit;
         echo json_encode([
                'status' => 'success',
                'message' => 'Data Deleted Successfully..!'
            ]);
    }
    public function update_achievements()
    {
         $achievement_id = $this->input->post('achievement_id');
        // $user_type = $this->input->post('user_type');
        $achievement_name = $this->input->post('achievement_name');

        // Simple validation
        if(!empty($achievement_name) && !empty($achievement_id)) {
            // You can insert into database here...
            $data = array(
                //'user_type' => $user_type,
                'achievement_name' => $achievement_name,
                'updated_on' => date('Y-m-d H:i:s')
                );
                $update = $this->mainmodel->common_update('achievements',$data,array('id' => $achievement_id));

            echo json_encode([
                'status' => 'success',
                'message' => 'Interest Details Updated successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }
/* cities module*/	
	public function list_cities()
	{
	    $this->load->view('includes/admin_header');
		$this->load->view('admin/list_cities');
		$this->load->view('includes/footer'); 
	}
	public function all_cities_info()
	{
	    $categories = $this->mainmodel->get_all_cities_details($_POST);
        $result_count=$this->mainmodel->get_all_cities_details($_POST,1); 
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}
	
	public function add_new_cities()
	{
        //$user_type = $this->input->post('user_type');
        $city_name = $this->input->post('city_name');

        // Simple validation
        if(!empty($city_name)) {
            $check = $this->mainmodel->common_fetch('cities',array('LOWER(city_name)' => strtolower($city_name)));
            if(empty($check)){
                $data = array(
               // 'user_type' => $user_type,
                'city_name' => $city_name,
                'created_on' => date('Y-m-d H:i:s')
                );
                $insert = $this->mainmodel->common_insert('cities',$data);

            echo json_encode([
                'status' => 'success',
                'message' => 'Form submitted successfully!'
            ]);
            }else{
                echo json_encode([
                'status' => 'error',
                'message' => 'Duplicate City name.'
            ]);
            }
            // You can insert into database here...
            
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }
    public function fetch_cities_data()
    {
        $id = $this->input->post('id');
        $fetch = $this->mainmodel->common_fetch('cities',array('id' => $id));
         echo json_encode([
                'status' => 'success',
                'message' => 'Data Fetched Successfully..!',
                'details' => $fetch
            ]);
    }
    public function delete_cities()
    {
        $id = $this->input->post('id');
        $fetch = $this->mainmodel->common_update('cities',array('delete_status' => 0,'updated_on' => date('Y-m-d H:i:s')),array('id' => $id));
        //echo $this->db->last_query();exit;
         echo json_encode([
                'status' => 'success',
                'message' => 'Data Deleted Successfully..!'
            ]);
    }
    public function update_cities()
    {
         $city_id = $this->input->post('city_id');
        // $user_type = $this->input->post('user_type');
        $city_name = $this->input->post('city_name');

        // Simple validation
        if(!empty($city_name) && !empty($city_id)) {
            // You can insert into database here...
            $data = array(
                //'user_type' => $user_type,
                'city_name' => $city_name,
                'updated_on' => date('Y-m-d H:i:s')
                );
                $update = $this->mainmodel->common_update('cities',$data,array('id' => $city_id));

            echo json_encode([
                'status' => 'success',
                'message' => 'City Details Updated successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }
/* foods module*/	
	public function list_foods()
	{
	    $this->load->view('includes/admin_header');
		$this->load->view('admin/list_foods');
		$this->load->view('includes/footer'); 
	}
	public function all_foods_info()
	{
	    $categories = $this->mainmodel->get_all_foods_details($_POST);
        $result_count=$this->mainmodel->get_all_foods_details($_POST,1); 
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}
	
	public function add_new_foods()
	{
        //$user_type = $this->input->post('user_type');
        $food_name = $this->input->post('food_name');

        // Simple validation
        if(!empty($food_name)) {
            // You can insert into database here...
            $data = array(
               // 'user_type' => $user_type,
                'food_name' => $food_name,
                'created_on' => date('Y-m-d H:i:s')
                );
                $insert = $this->mainmodel->common_insert('foods',$data);

            echo json_encode([
                'status' => 'success',
                'message' => 'Form submitted successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }
    public function fetch_foods_data()
    {
        $id = $this->input->post('id');
        $fetch = $this->mainmodel->common_fetch('foods',array('id' => $id));
         echo json_encode([
                'status' => 'success',
                'message' => 'Data Fetched Successfully..!',
                'details' => $fetch
            ]);
    }
    public function delete_foods()
    {
        $id = $this->input->post('id');
        $fetch = $this->mainmodel->common_update('foods',array('delete_status' => 0,'updated_on' => date('Y-m-d H:i:s')),array('id' => $id));
        //echo $this->db->last_query();exit;
         echo json_encode([
                'status' => 'success',
                'message' => 'Data Deleted Successfully..!'
            ]);
    }
    public function update_foods()
    {
         $food_id = $this->input->post('food_id');
        // $user_type = $this->input->post('user_type');
        $food_name = $this->input->post('food_name');

        // Simple validation
        if(!empty($food_name) && !empty($food_id)) {
            // You can insert into database here...
            $data = array(
                //'user_type' => $user_type,
                'food_name' => $food_name,
                'updated_on' => date('Y-m-d H:i:s')
                );
                $update = $this->mainmodel->common_update('foods',$data,array('id' => $food_id));

            echo json_encode([
                'status' => 'success',
                'message' => 'Food Details Updated successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }
    
/* cities module*/	
	public function list_professional_connections()
	{
	    $this->load->view('includes/admin_header');
		$this->load->view('admin/list_professional_connections');
		$this->load->view('includes/footer'); 
	}
	public function all_professional_connections_info()
	{
	    $categories = $this->mainmodel->get_all_professional_connections_details($_POST);
        $result_count=$this->mainmodel->get_all_professional_connections_details($_POST,1); 
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}
	
	public function add_new_professional_connections()
	{
        //$user_type = $this->input->post('user_type');
        $connection_name = $this->input->post('connection_name');

        // Simple validation
        if(!empty($connection_name)) {
            // You can insert into database here...
            $data = array(
               // 'user_type' => $user_type,
                'connection_name' => $connection_name,
                'created_on' => date('Y-m-d H:i:s')
                );
                $insert = $this->mainmodel->common_insert('professional_connections',$data);

            echo json_encode([
                'status' => 'success',
                'message' => 'Form submitted successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }
    public function fetch_professional_connections_data()
    {
        $id = $this->input->post('id');
        $fetch = $this->mainmodel->common_fetch('professional_connections',array('id' => $id));
         echo json_encode([
                'status' => 'success',
                'message' => 'Data Fetched Successfully..!',
                'details' => $fetch
            ]);
    }
    public function delete_professional_connections()
    {
        $id = $this->input->post('id');
        $fetch = $this->mainmodel->common_update('professional_connections',array('delete_status' => 0,'updated_on' => date('Y-m-d H:i:s')),array('id' => $id));
        //echo $this->db->last_query();exit;
         echo json_encode([
                'status' => 'success',
                'message' => 'Data Deleted Successfully..!'
            ]);
    }
    public function update_professional_connections()
    {
         $connection_id = $this->input->post('connection_id');
        // $user_type = $this->input->post('user_type');
        $connection_name = $this->input->post('connection_name');

        // Simple validation
        if(!empty($connection_name) && !empty($connection_id)) {
            // You can insert into database here...
            $data = array(
                //'user_type' => $user_type,
                'connection_name' => $connection_name,
                'updated_on' => date('Y-m-d H:i:s')
                );
                $update = $this->mainmodel->common_update('professional_connections',$data,array('id' => $connection_id));

            echo json_encode([
                'status' => 'success',
                'message' => 'Professional Connection Details Updated successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }
/* religions module*/	
	public function list_religions()
	{
	    $this->load->view('includes/admin_header');
		$this->load->view('admin/list_religions');
		$this->load->view('includes/footer'); 
	}
	public function all_religions_info()
	{
	    $categories = $this->mainmodel->get_all_religions_details($_POST);
        $result_count=$this->mainmodel->get_all_religions_details($_POST,1); 
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}
	
	public function add_new_religions()
	{
        //$user_type = $this->input->post('user_type');
        $religion_name = $this->input->post('religion_name');

        // Simple validation
        if(!empty($religion_name)) {
            // You can insert into database here...
            $data = array(
               // 'user_type' => $user_type,
                'religion_name' => $religion_name,
                'created_on' => date('Y-m-d H:i:s')
                );
                $insert = $this->mainmodel->common_insert('religions',$data);

            echo json_encode([
                'status' => 'success',
                'message' => 'Form submitted successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }
    public function fetch_religions_data()
    {
        $id = $this->input->post('id');
        $fetch = $this->mainmodel->common_fetch('religions',array('id' => $id));
         echo json_encode([
                'status' => 'success',
                'message' => 'Data Fetched Successfully..!',
                'details' => $fetch
            ]);
    }
    public function delete_religions()
    {
        $id = $this->input->post('id');
        $fetch = $this->mainmodel->common_update('religions',array('delete_status' => 0,'updated_on' => date('Y-m-d H:i:s')),array('id' => $id));
        //echo $this->db->last_query();exit;
         echo json_encode([
                'status' => 'success',
                'message' => 'Data Deleted Successfully..!'
            ]);
    }
    public function update_religions()
    {
         $religion_id = $this->input->post('religion_id');
        // $user_type = $this->input->post('user_type');
        $religion_name = $this->input->post('religion_name');

        // Simple validation
        if(!empty($religion_name) && !empty($religion_id)) {
            // You can insert into database here...
            $data = array(
                //'user_type' => $user_type,
                'religion_name' => $religion_name,
                'updated_on' => date('Y-m-d H:i:s')
                );
                $update = $this->mainmodel->common_update('religions',$data,array('id' => $religion_id));

            echo json_encode([
                'status' => 'success',
                'message' => 'Religion Details Updated successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }
    
    
    
    
 /* religions module*/	
	public function list_languages()
	{
	    $this->load->view('includes/admin_header');
		$this->load->view('admin/list_languages');
		$this->load->view('includes/footer'); 
	}
	public function all_languages_info()
	{
	    $categories = $this->mainmodel->get_all_languages_details($_POST);
        $result_count=$this->mainmodel->get_all_languages_details($_POST,1); 
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}
	
	public function add_new_languages()
	{
        //$user_type = $this->input->post('user_type');
        $language_name = $this->input->post('language_name');

        // Simple validation
        if(!empty($language_name)) {
            // You can insert into database here...
            $data = array(
               // 'user_type' => $user_type,
                'language_name' => $language_name,
                'created_on' => date('Y-m-d H:i:s')
                );
                $insert = $this->mainmodel->common_insert('languages',$data);

            echo json_encode([
                'status' => 'success',
                'message' => 'Form submitted successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }
    public function fetch_languages_data()
    {
        $id = $this->input->post('id');
        $fetch = $this->mainmodel->common_fetch('languages',array('id' => $id));
         echo json_encode([
                'status' => 'success',
                'message' => 'Data Fetched Successfully..!',
                'details' => $fetch
            ]);
    }
    public function delete_languages()
    {
        $id = $this->input->post('id');
        $fetch = $this->mainmodel->common_update('languages',array('delete_status' => 0,'updated_on' => date('Y-m-d H:i:s')),array('id' => $id));
        //echo $this->db->last_query();exit;
         echo json_encode([
                'status' => 'success',
                'message' => 'Data Deleted Successfully..!'
            ]);
    }
    public function update_languages()
    {
         $language_id = $this->input->post('language_id');
        // $user_type = $this->input->post('user_type');
        $language_name = $this->input->post('language_name');

        // Simple validation
        if(!empty($language_name) && !empty($language_id)) {
            // You can insert into database here...
            $data = array(
                //'user_type' => $user_type,
                'language_name' => $language_name,
                'updated_on' => date('Y-m-d H:i:s')
                );
                $update = $this->mainmodel->common_update('languages',$data,array('id' => $language_id));

            echo json_encode([
                'status' => 'success',
                'message' => 'Languages Details Updated successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }   
    
    

/* events module*/	
	public function list_events()
	{
	    $data['cities'] = $this->mainmodel->common_fetch('cities',array('delete_status' => 1));
	   // print_r($data);exit;
	    $this->load->view('includes/admin_header');
		$this->load->view('admin/list_events',$data);
		$this->load->view('includes/footer'); 
	}
	public function all_events_info()
	{
	   // print_r($_POST);exit;
	    $categories = $this->mainmodel->get_all_events_details($_POST);
        $result_count=$this->mainmodel->get_all_events_details($_POST,1); 
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}
	
	public function add_new_events()
	{
	   // echo "<pre>";
	   // print_r($_FILES);exit;
        $event_name = $this->input->post('event_name');
        $event_description = $this->input->post('event_description');
        $event_date = $this->input->post('event_date');
        $event_location = $this->input->post('event_location');
        $event_city = $this->input->post('event_city');
        $featured_event = $this->input->post('featured_event');

        // Simple validation
        if(!empty($event_name)) {
            // You can insert into database here...
             if(!empty($_FILES['event_image']['name'])){
	                $config['upload_path']          = 'assets/images/events/';
            		$config['allowed_types']        = 'jpg|png|gif|jpeg|webp';
            		$config['max_size']             = 2000;
            		
            		$this->load->library('upload', $config);
            		if($this->upload->do_upload('event_image')){
            			$imgdata = $this->upload->data();
            			$iconurl = 'assets/images/events/'.$imgdata['file_name'];
            		}else{
            			$iconurl = '';
            		}
	            }else{
	                	$iconurl = '';
	            }
	            
            $data = array(
                'event_name' => $event_name,
                'event_image' => $iconurl,
                'event_description' => $event_description,
                'event_date' => $event_date,
                'event_location' => $event_location,
                'event_city' => $event_city,
                'featured_event' => $featured_event,
                'created_on' => date('Y-m-d H:i:s')
                );
                $insert = $this->mainmodel->common_insert('events',$data);

            echo json_encode([
                'status' => 'success',
                'message' => 'Form submitted successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }
    public function fetch_events_data()
    {
        $id = $this->input->post('id');
        $fetch = $this->mainmodel->common_fetch('events',array('id' => $id));
         echo json_encode([
                'status' => 'success',
                'message' => 'Data Fetched Successfully..!',
                'details' => $fetch
            ]);
    }
    public function delete_event()
    {
        $id = $this->input->post('id');
        $event = $this->mainmodel->common_fetch('events',array('id' => $id));
        if(!empty($event[0]->event_image)){
            unlink($event[0]->event_image);
        }
        $fetch = $this->mainmodel->common_delete('events',array('id' => $id));
        //echo $this->db->last_query();exit;
         echo json_encode([
                'status' => 'success',
                'message' => 'Event Deleted Successfully..!'
            ]);
    }
    public function update_event()
    {
         // echo "<pre>";
	   // print_r($_FILES);exit;
        $event_id = $this->input->post('event_id');
        $event_name = $this->input->post('event_name');
        $event_description = $this->input->post('event_description');
        $event_date = $this->input->post('event_date');
        $event_location = $this->input->post('event_location');
        $event_city = $this->input->post('event_city');
        $featured_event = $this->input->post('featured_event');

        // Simple validation
        if(!empty($event_id)) {
            // You can insert into database here...
             $event = $this->mainmodel->common_fetch('events',array('id' => $event_id));
             if(!empty($_FILES['event_image']['name'])){
                 if(!empty($event[0]->event_image)){
                     unlink($event[0]->event_image);
                 }
	                $config['upload_path']          = 'assets/images/events/';
            		$config['allowed_types']        = 'jpg|png|gif|jpeg|webp';
            		$config['max_size']             = 2000;
            		
            		$this->load->library('upload', $config);
            		if($this->upload->do_upload('event_image')){
            			$imgdata = $this->upload->data();
            			$iconurl = 'assets/images/events/'.$imgdata['file_name'];
            		}else{
            			$iconurl = $event[0]->event_image;
            		}
	            }else{
	                	$iconurl = $event[0]->event_image;
	            }
	            
            $data = array(
                'event_name' => $event_name,
                'event_image' => $iconurl,
                'event_description' => $event_description,
                'event_date' => $event_date,
                'event_location' => $event_location,
                'event_city' => $event_city,
                'featured_event' => $featured_event,
                'updated_on' => date('Y-m-d H:i:s')
                );
                $update = $this->mainmodel->common_update('events',$data,array('id' => $event_id));

            echo json_encode([
                'status' => 'success',
                'message' => 'Event Details Updated successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }
    
/* subscriptions module*/	
	public function list_subscriptions()
	{
	    $this->load->view('includes/admin_header');
		$this->load->view('admin/list_subscriptions');
		$this->load->view('includes/footer'); 
	}
	public function all_subscriptions_info()
	{
	    $categories = $this->mainmodel->get_all_subscriptions_details($_POST);
        $result_count=$this->mainmodel->get_all_subscriptions_details($_POST,1); 
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}
	
	public function add_new_subscriptions()
	{
        //$user_type = $this->input->post('user_type');
        $religion_name = $this->input->post('religion_name');

        // Simple validation
        if(!empty($religion_name)) {
            // You can insert into database here...
            $data = array(
               // 'user_type' => $user_type,
                'religion_name' => $religion_name,
                'created_on' => date('Y-m-d H:i:s')
                );
                $insert = $this->mainmodel->common_insert('subscriptions',$data);

            echo json_encode([
                'status' => 'success',
                'message' => 'Form submitted successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }
    public function fetch_subscriptions_data()
    {
        $id = $this->input->post('id');
        $fetch = $this->mainmodel->common_fetch('subscriptions',array('id' => $id));
         echo json_encode([
                'status' => 'success',
                'message' => 'Data Fetched Successfully..!',
                'details' => $fetch
            ]);
    }
    public function delete_subscriptions()
    {
        $id = $this->input->post('id');
        $fetch = $this->mainmodel->common_update('subscriptions',array('delete_status' => 0,'updated_on' => date('Y-m-d H:i:s')),array('id' => $id));
        //echo $this->db->last_query();exit;
         echo json_encode([
                'status' => 'success',
                'message' => 'Data Deleted Successfully..!'
            ]);
    }
    
    public function edit_subscription($id)
    {
        $data['sub'] = $this->mainmodel->common_fetch('subscriptions',array('id' => $id));
        $data['sub_des'] = $this->mainmodel->common_fetch('sub_descriptions',array('sub_id' => $id));
        $this->load->view('includes/admin_header');
		$this->load->view('admin/edit_subscriptions',$data);
		$this->load->view('includes/footer'); 
    }
    public function update_subscriptions()
    {
       // echo "<pre>";
      //  print_r($_POST);exit;
         $sub_id = $this->input->post('sub_id');
         $sub_amount = $this->input->post('sub_amount');
        $descrition = $this->input->post('descrition');
        $descrition_ids = $this->input->post('descrition_ids');
 
        // Simple validation
        if(!empty($sub_id) && !empty($descrition) & !empty($descrition_ids)) {
            // You can insert into database here...
            $data = array(
                //'user_type' => $user_type,
                'sub_amount' => $sub_amount,
                'updated_on' => date('Y-m-d H:i:s')
                );
                $update = $this->mainmodel->common_update('subscriptions',$data,array('id' => $sub_id));
                
                for($i=0; $i< count($descrition_ids); $i++){
                    $data = array(
                'descrition' => $descrition[$i],
                'updated_on' => date('Y-m-d H:i:s')
                );
                $update = $this->mainmodel->common_update('sub_descriptions',$data,array('sub_id' => $sub_id,'id' => $descrition_ids[$i]));
                }

            echo json_encode([
                'status' => 'success',
                'message' => 'Subscription Details Updated successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }
    
    public function update_sub_status()
    {
	    $id = $this->input->post('id');
	    $status = $this->input->post('status');
	    if(!empty($id)){
	        if($status == 1)
	    {
	        $status = 0;
	    }else if($status == 0){
	       $status = 1; 
	    }
	    
	       $data = array(
	            'delete_status' => $status,
	            'updated_on' => date('Y-m-d H:i:s')
	            );
	           // print_r($data);
	           // echo $amenity.$id;exit;
	            $update_area = $this->mainmodel->common_update("subscriptions",$data,array('id' => $id));
	      // echo      $update_area;exit;
	      echo json_encode([
                'status' => 'success',
                'message' => 'Subscription status successfully!'
            ]);
	    
	    }else{
	         echo json_encode([
                'status' => 'error',
                'message' => 'Subscription status not updated.'
            ]);
	    }
	   // echo json_encode($josn_data);
		//		exit;
	}


/* Zones module*/	
	public function list_zones()
	{
	    $data['cities'] = $this->mainmodel->common_fetch('cities',array('delete_status' => 1));
	    $this->load->view('includes/admin_header');
		$this->load->view('admin/list_zones',$data);
		$this->load->view('includes/footer'); 
	}
	public function all_zones_info()
	{
	   // echo "<pre>";
	   // print_r($_POST);exit;
	    $categories = $this->mainmodel->get_all_zones_details($_POST);
        $result_count=$this->mainmodel->get_all_zones_details($_POST,1);
       // echo $this->db->last_query();exit;
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}
	
		public function add_zone()
	{
	    $data['cities'] = $this->mainmodel->common_fetch('cities',array('delete_status' => 1));
	     $this->load->view('includes/admin_header');
		$this->load->view('admin/add_zone',$data);
		$this->load->view('includes/footer');

	}
	
		public function add_zone_new()
	{
	    $data['cities'] = $this->mainmodel->common_fetch('cities',array('delete_status' => 1));
	     $this->load->view('includes/admin_header');
		$this->load->view('admin/add_zone_new',$data);
		$this->load->view('includes/footer');

	}
	
	 public function create_zone() {
    //     $json = file_get_contents('php://input');
    //     $data = json_decode($json, true);

    //     $zone_name = $data['zone_name'] ?? '';
    //     $boundaries = $data['boundaries'] ?? [];
    //         $zone_logo = null;
    // $zone_pic = null;
   // echo "<pre>";
    //print_r($_POST);exit;
        $zone_name = $this->input->post('zone_name');
              //  echo $zone_name;exit;

    $hottest_zone = $this->input->post('hottest_zone');
    $zone_city = $this->input->post('zone_city');
  //  $boundaries = json_decode($this->input->post('boundaries'), true);
        $boundaries = json_decode($this->input->post('boundaries'), true);
        
        // Validate
if (!$zone_name || !$boundaries || !$hottest_zone) {
    echo json_encode(['status' => false, 'message' => 'Missing fields']);
    return;
}



    $zone_logo = null;
    $zone_pic = null;
    
    // Upload logo
    // if (!empty($_FILES['zone_logo']['name'])) {
    //     $config['upload_path'] = './uploads/zones/';
    //     $config['allowed_types'] = 'jpg|jpeg|png|gif';
    //     $config['file_name'] = time() . '_logo';

    //     $this->load->library('upload', $config);
    //     if ($this->upload->do_upload('zone_logo')) {
    //         $zone_logo = $this->upload->data('file_name');
    //     } else {
    //         echo json_encode(['status' => false, 'message' => $this->upload->display_errors()]);
    //         return;
    //     }
    // }

    // Upload zone picture
    // if (!empty($_FILES['zone_pic']['name'])) {
    //     $config['file_name'] = time() . '_pic';
    //     $this->upload->initialize($config); // reinitialize for new file
    //     if ($this->upload->do_upload('zone_pic')) {
    //         $zone_pic = $this->upload->data('file_name');
    //     } else {
    //         echo json_encode(['status' => false, 'message' => $this->upload->display_errors()]);
    //         return;
    //     }
    // }
    
    

 if(!empty($_FILES['zone_pic']['name'])){
                //  if(!empty($event[0]->event_image)){
                //      unlink($event[0]->event_image);
                //  }
	                $config['upload_path']          = 'assets/images/zones/';
            		$config['allowed_types']        = 'jpg|png|gif|jpeg|webp';
            		$config['max_size']             = 2000;
            		
            		$this->load->library('upload', $config);
            		if($this->upload->do_upload('zone_pic')){
            			$imgdata = $this->upload->data();
            			$pic = 'assets/images/zones/'.$imgdata['file_name'];
            		}else{
            			$pic = "";
            		}
	            }else{
	                	$pic = "";
	            }

 if(!empty($_FILES['zone_logo']['name'])){
                //  if(!empty($event[0]->event_image)){
                //      unlink($event[0]->event_image);
                //  }
	                $config['upload_path']          = 'assets/images/zones/';
            		$config['allowed_types']        = 'jpg|png|gif|jpeg|webp';
            		$config['max_size']             = 2000;
            		
            		$this->load->library('upload', $config);
            		if($this->upload->do_upload('zone_logo')){
            			$imgdata = $this->upload->data();
            			$logo = 'assets/images/zones/'.$imgdata['file_name'];
            		}else{
            			$logo = "";
            		}
	            }else{
	                	$logo = "";
	            }

	        





        if ($zone_name && !empty($boundaries)) {
            $zone_id = $this->mainmodel->create_zone($zone_name, $boundaries,$hottest_zone,$zone_city,$pic,$logo);
            echo json_encode(['status' => true, 'message' => 'Zone created', 'zone_id' => $zone_id]);
        } else {
            echo json_encode(['status' => false, 'message' => 'Missing zone name or boundaries']);
        }
    }
    
      public function fetch_zones_data()
    {
        $id = $this->input->post('id');
        $fetch = $this->mainmodel->common_fetch('subscriptions',array('id' => $id));
         echo json_encode([
                'status' => 'success',
                'message' => 'Data Fetched Successfully..!',
                'details' => $fetch
            ]);
    }
    public function delete_zones()
    {
        $id = $this->input->post('id');
        $delete = $this->mainmodel->common_delete('zones',array('id' => $id));
        $delete = $this->mainmodel->common_delete('zone_boundaries',array('zone_id' => $id));
        $delete = $this->mainmodel->common_delete('user_in_zone',array('zone_id' => $id));
        //echo $this->db->last_query();exit;
         echo json_encode([
                'status' => 'success',
                'message' => 'Data Deleted Successfully..!'
            ]);
    }
    
    public function edit_zone($id)
    {
        $data['zone'] = $this->mainmodel->common_fetch('zones',array('id' => $id));
        $data['boundaries'] = $this->mainmodel->common_fetch('zone_boundaries',array('zone_id' => $id));
        $data['cities'] = $this->mainmodel->common_fetch('cities',array('delete_status' => 1));
        $this->load->view('includes/admin_header');
		$this->load->view('admin/edit_zones',$data);
		$this->load->view('includes/footer'); 
    }
    public function update_zones()
    {
        // $json = file_get_contents('php://input');
        // $data = json_decode($json, true);

        // $zone_name = $data['zone_name'] ?? '';
        // $boundaries = $data['boundaries'] ?? [];
        // $zone_id = $data['zone_id'] ?? [];
       // echo "<pre>";
       // print_r($boundaries);exit;
       
        $zone_id = $this->input->post('zone_id');
        $zone_name = $this->input->post('zone_name');
        $zone_city = $this->input->post('zone_city');
              //  echo $zone_name;exit;

    $hottest_zone = $this->input->post('hottest_zone');
  //  $boundaries = json_decode($this->input->post('boundaries'), true);
        $boundaries = json_decode($this->input->post('boundaries'), true);
        
        // Validate
if (!$zone_name || !$boundaries || !$hottest_zone || !$zone_id) {
    echo json_encode(['status' => false, 'message' => 'Missing fields']);
    return;
}
    $zone_logo = null;
    $zone_pic = null;
    
    $fetch = $this->mainmodel->common_fetch('zones',array('id' => $zone_id));
    if(!empty($_FILES['zone_pic']['name'])){
                 if(!empty($fetch[0]->zone_pic)){
                     unlink($fetch[0]->zone_pic);
                 }
	                $config['upload_path']          = 'assets/images/zones/';
            		$config['allowed_types']        = 'jpg|png|gif|jpeg|webp';
            		$config['max_size']             = 2000;
            		
            		$this->load->library('upload', $config);
            		if($this->upload->do_upload('zone_pic')){
            			$imgdata = $this->upload->data();
            			$pic = 'assets/images/zones/'.$imgdata['file_name'];
            		}else{
            			$pic = $fetch[0]->zone_pic;
            		}
	            }else{
	                	$pic = $fetch[0]->zone_pic;
	            }

 if(!empty($_FILES['zone_logo']['name'])){
                 if(!empty($fetch[0]->zone_logo)){
                     unlink($fetch[0]->zone_logo);
                 }
	                $config['upload_path']          = 'assets/images/zones/';
            		$config['allowed_types']        = 'jpg|png|gif|jpeg|webp';
            		$config['max_size']             = 2000;
            		
            		$this->load->library('upload', $config);
            		if($this->upload->do_upload('zone_logo')){
            			$imgdata = $this->upload->data();
            			$logo = 'assets/images/zones/'.$imgdata['file_name'];
            		}else{
            			$logo = $fetch[0]->zone_logo;
            		}
	            }else{
	                	$logo = $fetch[0]->zone_logo;
	            }


    
        
 
        // Simple validation
        if(!empty($zone_name) && !empty($boundaries) & !empty($zone_id)) {
            // You can insert into database here...
              // Update zone name
    $this->db->where('id', $zone_id)->update('zones', 
    [
    
        'name' => $zone_name,
            'hottest_zone'=>$hottest_zone,
            'zone_city' => $zone_city,
            'zone_logo'=>$logo,
            'zone_pic'=>$pic,
            'created_on' => date('Y-m-d H:i:s')
    
    ]);

    // Delete old boundaries
    $this->db->where('zone_id', $zone_id)->delete('zone_boundaries');

    // Insert new boundaries
    foreach ($boundaries as $point) {
        $this->db->insert('zone_boundaries', [
            'zone_id' => $zone_id,
            'latitude' => $point['lat'],
            'longitude' => $point['lng']
        ]);
    }
    

            echo json_encode([
                'status' => 'success',
                'message' => 'Zone Details Updated successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }
    
    public function update_zone_status()
    {
	    $id = $this->input->post('id');
	    $status = $this->input->post('status');
	    if(!empty($id)){
	        if($status == 1)
	    {
	        $status = 0;
	    }else if($status == 0){
	       $status = 1; 
	    }
	    
	       $data = array(
	            'status' => $status,
	            'updated_on' => date('Y-m-d H:i:s')
	            );
	           // print_r($data);
	           // echo $amenity.$id;exit;
	            $update_area = $this->mainmodel->common_update("zones",$data,array('id' => $id));
	      // echo      $update_area;exit;
	      echo json_encode([
                'status' => 'success',
                'message' => 'Zone status successfully!'
            ]);
	    
	    }else{
	         echo json_encode([
                'status' => 'error',
                'message' => 'Zone status not updated.'
            ]);
	    }
	   // echo json_encode($josn_data);
		//		exit;
	}
    
    
    
    
    public function edit_aboutus()
    {
        $data['about'] = $this->mainmodel->common_fetch('about_us',array('id' => 1));
        $this->load->view('includes/admin_header');
		$this->load->view('admin/edit_about',$data);
		$this->load->view('includes/footer'); 
    }
    
     public function update_about()
    {
         $about_id = $this->input->post('about_id');
        $content = $this->input->post('content');

        // Simple validation
        if(!empty($content) && !empty($about_id)) {
            // You can insert into database here...
            $data = array(
                //'user_type' => $user_type,
                'content' => $content,
                'updated_on' => date('Y-m-d H:i:s')
                );
                $update = $this->mainmodel->common_update('about_us',$data,array('id' => $about_id));

            echo json_encode([
                'status' => 'success',
                'message' => 'About Us Content Updated successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }
    
    public function edit_termsandconditions()
    {
        $data['term'] = $this->mainmodel->common_fetch('terms_and_conditons',array('id' => 1));
        $this->load->view('includes/admin_header');
		$this->load->view('admin/edit_termsandconditions',$data);
		$this->load->view('includes/footer'); 
    }
    
     public function update_termsandconditions()
    {
         $term_id = $this->input->post('term_id');
        $content = $this->input->post('content');

        // Simple validation
        if(!empty($content) && !empty($term_id)) {
            // You can insert into database here...
            $data = array(
                //'user_type' => $user_type,
                'content' => $content,
                'updated_on' => date('Y-m-d H:i:s')
                );
                $update = $this->mainmodel->common_update('terms_and_conditons',$data,array('id' => $term_id));

            echo json_encode([
                'status' => 'success',
                'message' => 'Terms and Conditions Content Updated successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }
    
    public function edit_privacypolicy()
    {
        $data['privacy'] = $this->mainmodel->common_fetch('privacy_policy',array('id' => 1));
        $this->load->view('includes/admin_header');
		$this->load->view('admin/edit_privacypolicy',$data);
		$this->load->view('includes/footer'); 
    }
    
     public function update_privacypolicy()
    {
         $privacy_id = $this->input->post('privacy_id');
        $content = $this->input->post('content');

        // Simple validation
        if(!empty($content) && !empty($privacy_id)) {
            // You can insert into database here...
            $data = array(
                //'user_type' => $user_type,
                'content' => $content,
                'updated_on' => date('Y-m-d H:i:s')
                );
                $update = $this->mainmodel->common_update('privacy_policy',$data,array('id' => $privacy_id));

            echo json_encode([
                'status' => 'success',
                'message' => 'Privacy Policy Content Updated successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }
    
    public function edit_cookiespolicy()
    {
        $data['refund'] = $this->mainmodel->common_fetch('cookies_policy',array('id' => 1));
        $this->load->view('includes/admin_header');
		$this->load->view('admin/edit_cookiespolicy',$data);
		$this->load->view('includes/footer'); 
    }
    
     public function update_cookiespolicy()
    {
         $refund_id = $this->input->post('refund_id');
         $content = $this->input->post('content');

        // Simple validation
        if(!empty($content) && !empty($refund_id)) {
            // You can insert into database here...
            $data = array(
                //'user_type' => $user_type,
                'content' => $content,
                'updated_on' => date('Y-m-d H:i:s')
                );
                $update = $this->mainmodel->common_update('cookies_policy',$data,array('id' => $refund_id));

            echo json_encode([
                'status' => 'success',
                'message' => 'Cookies Policy Content Updated successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }
    
    
    public function edit_refundpolicy()
    {
        $data['refund'] = $this->mainmodel->common_fetch('return_and_refund_policy',array('id' => 1));
        $this->load->view('includes/admin_header');
		$this->load->view('admin/edit_refundpolicy',$data);
		$this->load->view('includes/footer'); 
    }
    
     public function update_refundpolicy()
    {
         $refund_id = $this->input->post('refund_id');
         $content = $this->input->post('content');

        // Simple validation
        if(!empty($content) && !empty($refund_id)) {
            // You can insert into database here...
            $data = array(
                //'user_type' => $user_type,
                'content' => $content,
                'updated_on' => date('Y-m-d H:i:s')
                );
                $update = $this->mainmodel->common_update('return_and_refund_policy',$data,array('id' => $refund_id));

            echo json_encode([
                'status' => 'success',
                'message' => 'Return & Refund Policy Content Updated successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }
    
    
    
    public function list_user_contact()
	{
	    $this->load->view('includes/admin_header');
		$this->load->view('admin/list_user_contact');
		$this->load->view('includes/footer'); 
	}
	public function all_user_contact_info()
	{
	   // echo "<pre>";
	   // print_r($_POST);exit;
	    $categories = $this->mainmodel->get_all_user_contact_details($_POST);
        $result_count=$this->mainmodel->get_all_user_contact_details($_POST,1);
       // echo $this->db->last_query();exit;
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}
	
	
	  public function send_notifications()
    {
        $data['users'] = $this->mainmodel->common_fetch('users',array('delete_status' => 1));
        $this->load->view('includes/admin_header');
		$this->load->view('admin/send_notifications',$data);
		$this->load->view('includes/footer'); 
    }
    
//     	 public function sendNotification($playerId, $title, $message, $user_type = null) {
//     // $appId = '1ad1bebd-28dd-47d6-b471-98bc6d9531b8'; // Replace with your OneSignal App ID
//     // $apiKey = 'os_v2_app_dli35pji3vd5nndrtc6g3fjrxbsekwdb4oauhdeiq3xmzqhnsfalmohwdceqvu25e2mbglzdhrsixb22jnqfyguqwec3kkwjyuwsrra'; // Replace with your OneSignal REST API Key
    
    
//      $appId = '34866b81-82c4-4fec-b39a-95f9ac395de3'; // Replace with your OneSignal App ID
//     $apiKey = 'os_v2_app_gsdgxamcyrh6zm42sx42yok54obloqi5dslu435fykdqdy4euwql2se25hapqag2ie7uv34tgji6ln5ez4v37skb7vw3l2el736enli'; // Replace with your OneSignal REST API Key
   
   
   
//     $curl = curl_init();

//     // Common notification data
//     $notificationData = [
//         "app_id" => $appId,
//         "headings" => ["en" => $title], // Notification title
//         "contents" => ["en" => $message], // Notification content
//         "small_icon" => "gross_bytes_logo", // Android Small Icon (Place inside res/drawable),
//     ];

//     // 1️⃣ *Sending to ALL Users*
//     if ($playerId == 'all') {
//         //$notificationData["included_segments"] = ["All"]; // Send to all users
//         $notificationData["filters"] = [
//             ["field" => "tag", "key" => "user_type", "relation" => "=", "value" => $user_type]
//         ];
    
//     // 2️⃣ *Sending to a Filtered User Type (e.g., Only Employees or Only Users)*
//     } /*elseif ($userType !== null) {
        
    
//     // 3️⃣ *Sending to Multiple Specific Users*
//     }*/ elseif (is_array($playerId)) {
//         $notificationData["include_player_ids"] = $playerId; // Send to multiple users
    
//     // 4️⃣ *Sending to a Single User*
//     } else {
//         $notificationData["include_player_ids"] = [$playerId]; // Send to a single user
//     }

//     curl_setopt_array($curl, [
//         CURLOPT_URL => "https://onesignal.com/api/v1/notifications",
//         CURLOPT_RETURNTRANSFER => true,
//         CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
//         CURLOPT_CUSTOMREQUEST => "POST",
//         CURLOPT_POSTFIELDS => json_encode($notificationData),
//         CURLOPT_HTTPHEADER => [
//             "Authorization: Key $apiKey", // API Key in Authorization header
//             "Content-Type: application/json"
//         ],
//         CURLOPT_SSL_VERIFYPEER => false, // Disable SSL verification for debugging
//     ]);

//     $response = curl_exec($curl);
//     $err = curl_error($curl);
//     curl_close($curl);

//     if ($err) {
//         return "cURL Error: " . $err;
//     } else {
//         return  $response;
//     }
// }

//     public function sendNotification($playerId, $title, $message, $user_type = null) {
//     $appId = '34866b81-82c4-4fec-b39a-95f9ac395de3'; // OneSignal App ID
//     $apiKey = 'os_v2_app_gsdgxamcyrh6zm42sx42yok54obloqi5dslu435fykdqdy4euwql2se25hapqag2ie7uv34tgji6ln5ez4v37skb7vw3l2el736enli'; // OneSignal REST API Key

//     // Validate input
//     if (empty($playerId)) {
//         return json_encode([
//             'status' => false,
//             'message' => 'Player ID is empty.'
//         ]);
//     }

//     // Common payload
//     $notificationData = [
//         "app_id" => $appId,
//         "headings" => ["en" => $title],
//         "contents" => ["en" => $message],
//         "small_icon" => "u_icon",
//     ];

//     // Targeting logic
//     if ($playerId === 'all') {
//         // Send to all users of specific user_type (tag must be set in mobile app)
//         $notificationData["filters"] = [
//             ["field" => "tag", "key" => "user_type", "relation" => "=", "value" => $user_type]
//         ];
//     } elseif (is_array($playerId)) {
//         // Send to multiple users
//         $notificationData["include_player_ids"] = $playerId;
//     } else {
//         // Send to a single user
//         $notificationData["include_player_ids"] = [$playerId];
//     }

//     // cURL setup
//     $curl = curl_init();
//     curl_setopt_array($curl, [
//         CURLOPT_URL => "https://onesignal.com/api/v1/notifications",
//         CURLOPT_RETURNTRANSFER => true,
//         CURLOPT_CUSTOMREQUEST => "POST",
//         CURLOPT_POSTFIELDS => json_encode($notificationData),
//         CURLOPT_HTTPHEADER => [
//             "Authorization: Key $apiKey",
//             "Content-Type: application/json"
//         ],
//         CURLOPT_SSL_VERIFYPEER => false
//     ]);

//     // Execute and handle response
//     $response = curl_exec($curl);
//     $err = curl_error($curl);
//     curl_close($curl);

//     if ($err) {
//         return json_encode([
//             'status' => false,
//             'message' => 'cURL Error: ' . $err
//         ]);
//     }

//     $responseData = json_decode($response, true);

//     // Check for OneSignal API errors
//     if (isset($responseData['errors'])) {
//         return json_encode([
//             'status' => false,
//             'message' => 'OneSignal error',
//             'errors' => $responseData['errors']
//         ]);
//     }

//     // Success
//     return json_encode([
//         'status' => true,
//         'message' => 'Notification sent successfully',
//         'response' => $responseData
//     ]);
// }

// public function sendNotification($playerId, $title, $message, $user_type = null, $imageUrl = null) {
//     $appId = '34866b81-82c4-4fec-b39a-95f9ac395de3'; // OneSignal App ID
//     $apiKey = 'os_v2_app_gsdgxamcyrh6zm42sx42yok54obloqi5dslu435fykdqdy4euwql2se25hapqag2ie7uv34tgji6ln5ez4v37skb7vw3l2el736enli'; // OneSignal REST API Key

//     if (empty($playerId)) {
//         return json_encode([
//             'status' => false,
//             'message' => 'Player ID is empty.'
//         ]);
//     }

//     // Common payload
//     $notificationData = [
//         "app_id" => $appId,
//         "headings" => ["en" => $title],
//         "contents" => ["en" => $message],
//         "small_icon" => "no_bg_logo",
//      //    "big_picture" => 'https://odigossoft.in/uapp/assets/images/users_pics681b49a83bbcc.png', 
      
//     ];

//     // Include image if provided
//     // if (!empty($imageUrl)) {
//     //     $notificationData["big_picture"] = $imageUrl; // For Android
//     //     $notificationData["ios_attachments"] = [
//     //         "id" => $imageUrl // For iOS
//     //     ];
//     // }
    
//     if (!empty($imageUrl)) {
         
//     $notificationData["big_picture"] = base_url().$imageUrl; // Android
//     $notificationData["ios_attachments"] = [ "id" => base_url().$imageUrl ]; // iOS
//     $notificationData["chrome_web_image"] = base_url().$imageUrl;; // Web push (optional)
//     $notificationData["android_picture"] = base_url().$imageUrl;; // Android legacy fallback
// }





//     // Targeting logic
//     // if ($playerId === 'all') {
//     //     $notificationData["filters"] = [
//     //         ["field" => "tag", "key" => "user_type", "relation" => "=", "value" => $user_type]
//     //     ];
//     // }
    
//     if ($playerId === 'all') {
//     $notificationData["included_segments"] = ["Subscribed Users"];
// }
//     elseif (is_array($playerId)) {
//         $notificationData["include_player_ids"] = $playerId;
//     } else {
//         $notificationData["include_player_ids"] = [$playerId];
//     }

//     // cURL setup
//     $curl = curl_init();
//     curl_setopt_array($curl, [
//         CURLOPT_URL => "https://onesignal.com/api/v1/notifications",
//         CURLOPT_RETURNTRANSFER => true,
//         CURLOPT_CUSTOMREQUEST => "POST",
//         CURLOPT_POSTFIELDS => json_encode($notificationData),
//         CURLOPT_HTTPHEADER => [
//             "Authorization: Key $apiKey",
//             "Content-Type: application/json"
//         ],
//         CURLOPT_SSL_VERIFYPEER => false
//     ]);

//     // Execute and handle response
//     $response = curl_exec($curl);
//     $err = curl_error($curl);
//     curl_close($curl);

//     if ($err) {
//         return json_encode([
//             'status' => false,
//             'message' => 'cURL Error: ' . $err
//         ]);
//     }

//     $responseData = json_decode($response, true);

//     if (isset($responseData['errors'])) {
//         return json_encode([
//             'status' => false,
//             'message' => 'OneSignal error',
//             'errors' => $responseData['errors']
//         ]);
//     }

//     return json_encode([
//         'status' => true,
//         'message' => 'Notification sent successfully',
//         'response' => $responseData
//     ]);
// }


public function sendNotification($playerId, $title, $message, $user_type = null, $imageUrl = null) {
    $appId = '34866b81-82c4-4fec-b39a-95f9ac395de3'; // OneSignal App ID
    $apiKey = 'os_v2_app_gsdgxamcyrh6zm42sx42yok54obloqi5dslu435fykdqdy4euwql2se25hapqag2ie7uv34tgji6ln5ez4v37skb7vw3l2el736enli'; // OneSignal REST API Key

    if (empty($playerId)) {
        return json_encode([
            'status' => false,
            'message' => 'Player ID is empty.'
        ]);
    }

    $notificationData = [
        "app_id" => $appId,
        "headings" => ["en" => $title],
        "contents" => ["en" => $message],
        "small_icon" => "no_bg_logo",
    ];

    // Add image to payload if provided
    if (!empty($imageUrl)) {
        $fullImageUrl = base_url() . ltrim($imageUrl, '/');
        $notificationData["big_picture"] = $fullImageUrl; // Android
        $notificationData["ios_attachments"] = ["id" => $fullImageUrl]; // iOS
        $notificationData["chrome_web_image"] = $fullImageUrl; // Web push
        $notificationData["android_picture"] = $fullImageUrl; // Android fallback
    }

    // Targeting logic
    // if ($playerId === 'all') {
    //   $notificationData["included_segments"] = ["Subscribed Users"]; // Only works if users are subscribed
    //   //  $notificationData["include_player_ids"] = ['6a8f1845-abe2-4f91-a0ac-667233493d60'];

    // }
    
    
    
    if ($playerId === 'all') {
  
    $playerIds = $this->mainmodel->getAllActivePlayerIds();

    $notificationData["include_player_ids"] = $playerIds;
}

elseif (is_array($playerId)) {
        $notificationData["include_player_ids"] = $playerId;
    } else {
        $notificationData["include_player_ids"] = [$playerId];
    }

    // cURL setup
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => "https://onesignal.com/api/v1/notifications",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => json_encode($notificationData),
        CURLOPT_HTTPHEADER => [
            "Authorization: Key $apiKey",
            "Content-Type: application/json"
        ],
        CURLOPT_SSL_VERIFYPEER => false
    ]);

    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);

    if ($err) {
        return json_encode([
            'status' => false,
            'message' => 'cURL Error: ' . $err
        ]);
    }

    $responseData = json_decode($response, true);

    if (isset($responseData['errors'])) {
        return json_encode([
            'status' => false,
            'message' => 'OneSignal error',
            'errors' => $responseData['errors']
        ]);
    }

    return json_encode([
        'status' => true,
        'message' => 'Notification sent successfully',
        'response' => $responseData
    ]);
}

     public function update_notifications()
    {
         $user_id = $this->input->post('users');
        $title = $this->input->post('title');
        $content = $this->input->post('content');

        // Simple validation
        if(!empty($content) && !empty($user_id) && !empty($title)) {
            
             if(!empty($_FILES['notification_image']['name'])){
	                $config['upload_path']          = 'assets/images/notifications/';
            		$config['allowed_types']        = 'jpg|png|gif|jpeg|webp';
            		$config['max_size']             = 2000;
            		
            		$this->load->library('upload', $config);
            		if($this->upload->do_upload('notification_image')){
            			$imgdata = $this->upload->data();
            			$iconurl = 'assets/images/notifications/'.$imgdata['file_name'];
            		}else{
            			$iconurl = '';
            		}
	            }else{
	                	$iconurl = '';
	            }
	        
	        
            // You can insert into database here...
            // $data = array(
            //     //'user_type' => $user_type,
            //     'content' => $content,
            //     'updated_on' => date('Y-m-d H:i:s')
            //     );
            //     $update = $this->mainmodel->common_update('privacy_policy',$data,array('id' => $privacy_id));
            
            if($user_id != "all"){
                     $users = $this->mainmodel->common_fetch('users',array('id' => $user_id));
                     $player_id = $users[0]->player_id;
                 }else{
                     $player_id = 'all';
                 }
                  $user_type = '';
                  $notification_name = $title;
                  $notification_content = $content;
                
                    $this->sendNotification($player_id,$notification_name,$notification_content,$user_type,$iconurl);//exit;

//exit;


            echo json_encode([
                'status' => 'success',
                'message' => 'Notification sent to users successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }
  
	
	



    
    
    
    
   

	
	  
	
	/* total users */
	
	public function list_users()
	{
	    $this->load->view('includes/admin_header');
		$this->load->view('admin/list_users');
		$this->load->view('includes/footer'); 
	}
	public function all_users_info()
	{
	    $categories = $this->mainmodel->get_all_users_details($_POST);
        $result_count=$this->mainmodel->get_all_users_details($_POST,1); 
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}
	public function update_user_status()
	{
	    $id = $this->input->post('id');
	    $status = $this->input->post('status');
	    if(!empty($id)){
	        if($status == 1)
	    {
	        $status = 0;
	    }else if($status == 0){
	       $status = 1; 
	    }
	    
	       $data = array(
	            'status' => $status,
	            'updated_on' => date('Y-m-d H:i:s')
	            );
	           // print_r($data);
	           // echo $amenity.$id;exit;
	            $update_area = $this->mainmodel->common_update("users",$data,array('id' => $id));
	      // echo      $update_area;exit;
	      echo json_encode([
                'status' => 'success',
                'message' => 'User status Updated successfully!'
            ]);
	    
	    }else{
	         echo json_encode([
                'status' => 'error',
                'message' => 'User status not updated.'
            ]);
	    }
	   // echo json_encode($josn_data);
		//		exit;
	}
	
	 public function delete_user()
    {
        $id = $this->input->post('id');
        $fetch = $this->mainmodel->common_update('users',array('delete_status' => 0,'updated_on' => date('Y-m-d H:i:s')),array('id' => $id));
       // echo $this->db->last_query();exit;
         echo json_encode([
                'status' => 'success',
                'message' => 'Data Deleted Successfully..!'
            ]);
    }
	
	
		/* total users */
		
		
		
		
		
		/* change password */
		public function change_password()
		{
		    $this->load->view('includes/admin_header');
		$this->load->view('admin/change_password');
		$this->load->view('includes/footer'); 
		}
		public function update_new_password()
		{
		   // echo "<pre>";
		  //  print_r($_POST);exit;
		    
		    if ($_SERVER['REQUEST_METHOD'] == 'POST') {

		     $password = $this->input->post('password');
	         $c_password = $this->input->post('c_password');
	   
		     $data = array(
        	            'password' => md5($password),
        	            'updated_on' => date('Y-m-d H:i:s')
        	            );
        	            $update = $this->mainmodel->common_update('admin',$data,array('id' => 1));
        	             echo json_encode([
                'status' => 'success',
                'message' => 'New Password Updated successfully!'
            ]);
                    
		    }else{
		        echo json_encode([
                'status' => 'error',
                'message' => 'New Password not updated.'
            ]);
		    }
		}
		/* change password */
	
	public function list_payments()
	{
	    $this->load->view('includes/admin_header');
		$this->load->view('admin/list_payments');
		$this->load->view('includes/footer'); 
	}
	public function all_payments_info()
	{
	    $categories = $this->mainmodel->get_all_payments_details($_POST);
        $result_count=$this->mainmodel->get_all_payments_details($_POST,1); 
        $json_data = array(
            "draw"  => intval($_POST['draw']),
            "iTotalRecords"  => intval($result_count),
            "iTotalDisplayRecords"  => intval($result_count),
            "recordsFiltered"  => intval(count($categories)),
            "data"  => $categories);  
        echo json_encode($json_data);
	}
	

     public function edit_app_version()
    {
        $data['refund'] = $this->mainmodel->common_fetch('ios_app_version',array('id' => 1));
        $this->load->view('includes/admin_header');
		$this->load->view('admin/edit_app_version',$data);
		$this->load->view('includes/footer'); 
    }
    
     public function update_app_version()
    {
         $version_id = $this->input->post('version_id');
         $version = $this->input->post('version');

        // Simple validation
        if(!empty($version) && !empty($version_id)) {
            // You can insert into database here...
            $data = array(
                //'user_type' => $user_type,
                'version' => $version,
                'updated_on' => date('Y-m-d H:i:s')
                );
                $update = $this->mainmodel->common_update('ios_app_version',$data,array('id' => $version_id));

            echo json_encode([
                'status' => 'success',
                'message' => 'App version Updated successfully!'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please fill in all fields.'
            ]);
        }
    }
   

	
	
	
	
	
	

	

}//end of page
