<div class="container-xxl flex-grow-1 container-p-y">
              <h4 class="py-3 mb-4"><span class="text-muted fw-light">Hospital Doctor Online Booking</h4>
             
  <div class="row"><div class="col-md-6">
      <div class="card mb-4">
          <form method="post" action="#" id="inputform" enctype="multipart/form-data">
        <div class="card-body">
            
            <div class="mb-3">
            <label for="userSearch">Users *</label>
                <input type="text" id="userSearch" class="form-control" placeholder="Type name or mobile or unique id" onkeyup="filterUsers()">
                
                <select id="userSelect" name="user_id" class="form-select mt-2" size="5" style="display:none;" required placeholder="User">
                    <?php if(!empty($users)){ 
                        foreach($users as $row){ ?>
                            <option value="<?= $row['id'] ?>"><?= $row['name'] ?> (<?= $row['mobile'] ?>) (<?= $row['unique_id'] ?>)</option>
                    <?php } } ?>
                </select>
          </div>
          
          <div class="mb-3">
            <label for="exampleFormControlInput1" class="form-label">Family Members *</label>
            <select class="form-select" name="family_member_id" required placeholder="Family Member">
            
            </select>
          </div>
          
            <div class="mb-3">
                <label for="hospitalSearch" class="form-label">Hospitals *</label>
                
                <!-- Search box -->
                <input type="text" id="hospitalSearch" class="form-control" placeholder="Type hospital name or mobile" onkeyup="filterHospitals()">
                
                <!-- Dropdown -->
                <select id="hospitalSelect" name="main_data_id" class="form-select mt-2" size="5" style="display:none;" required placeholder="Hospital">
                    <?php if(!empty($hospitals)){ 
                        foreach($hospitals as $roww){ ?>
                            <option value="<?= $roww['id'] ?>"><?= $roww['name'] ?> (<?= $roww['mobile'] ?>)</option>
                    <?php } } ?>
                </select>
            </div>
            
            <div class="mb-3">
            <label for="exampleFormControlInput1" class="form-label">Specialities *</label>
            <select class="form-select" name="speciality_id" required placeholder="Speciality" id="speciality_id">
            
            </select>
          </div>
          
          <div class="mb-3">
            <label for="exampleFormControlInput1" class="form-label">Doctors *</label>
            <select class="form-select" name="doctor_id" required placeholder="Doctor" id="doctor_id">
            
            </select>
          </div>
          
          <div class="mb-3">
                <label for="fee" class="form-label">Fee *</label>
                <input type="text" name="fee" class="form-control" placeholder="Fee" id="fee" required readonly>
            </div>
            
            <div class="mb-3">
                <label for="consultation_fee" class="form-label">Total Fee *</label>
                <input type="text" name="consultation_fee" class="form-control" placeholder="Consultation Fee" id="consultation_fee" required readonly>
            </div>
            
            <div class="mb-3">
                <label class="form-label">Apply Coupon</label>
                <div id="couponContainer" class="border rounded p-2" style="max-height: 200px; overflow-y:auto;">
                    <!-- Coupons will be loaded here dynamically -->
                    <p class="text-muted">Loading coupons...</p>
                </div>
            </div>
            
            <!-- add these hidden fields inside your <form> -->
            <input type="hidden" name="applied_coupon_id" id="applied_coupon_id" value="">
            <input type="hidden" name="applied_coupon_code" id="applied_coupon_code" value="">
            <input type="hidden" name="applied_coupon_discount" id="applied_coupon_discount" value="">
            <input type="hidden" name="applied_coupon_amount" id="applied_coupon_amount" value="">



            
            <div class="mb-3">
                <label for="datePicker" class="form-label">Dates *</label>
                <input type="text" name="date" class="form-control" placeholder="Date" id="date" required>
            </div>
            
            
            <div class="mb-3">
                <label for="exampleFormControlInput1" class="form-label">Time Slots *</label>
                <div id="slotContainer">
                    <p class="text-muted">Please select a date to view available slots.</p>
                </div>
            </div>
        
        </div>
      </div>
      
        <input type="hidden" id="cashfree_order_id" name="cashfree_order_id">
        <input type="hidden" id="cashfree_order_token" name="cashfree_order_token">
        <input type="hidden" id="payment_status" name="payment_status" value="pending">

       <button type="button" name="sub" value="sub" class="btn btn-success" id="saveBtn">Submit</button>
      </form>
      <!--<a href="<?=base_url('admin/register/hospital_notifications')?>"><button type="button" class="btn btn-danger">Cancel</button></a>-->
    </div></div>
</div>

<!-- Flatpickr CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">

<!-- Flatpickr JS -->
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>

<script>
document.addEventListener("DOMContentLoaded", function () {
    const dateInput = document.getElementById('date');
    const slotContainer = document.getElementById('slotContainer');

    // Set today's date as minimum
    const today = new Date().toISOString().split('T')[0];
    dateInput.setAttribute('min', today);

    // Load slots on date change
    dateInput.addEventListener('change', function () {
        const selectedDate = this.value;
        const hospital_id = document.getElementById('hospitalSelect').value; 
        const doctor_id = document.getElementById('doctor_id').value; // ðŸ‘ˆ doctor id

        if (!selectedDate || !hospital_id || !doctor_id) {
            slotContainer.innerHTML = '<p class="text-danger">Please select hospital & doctor first.</p>';
            return;
        }

        fetch("<?= base_url('admin/register/get_doctor_slots_by_date') ?>", {
            method: "POST",
            headers: { "Content-Type": "application/x-www-form-urlencoded" },
            body: "date=" + encodeURIComponent(selectedDate) 
                + "&hospital_id=" + encodeURIComponent(hospital_id) 
                + "&doctor_id=" + encodeURIComponent(doctor_id)
        })
        .then(response => response.json())
        .then(slots => {
            let html = '';
            const sections = ['morning', 'afternoon', 'evening'];
            let hasSlots = false;

            sections.forEach(section => {
                if (slots[section] && slots[section].length > 0) {
                    hasSlots = true;
                    html += `<div class="mb-2"><strong>${section.charAt(0).toUpperCase() + section.slice(1)}</strong><br>`;
                    slots[section].forEach((slot, i) => {
                        const id = `${section}_${i}`;
                        const isBooked = slot.booking_status === 'booked';
            
                        html += `
                            <label for="${id}" class="me-2 ${isBooked ? 'text-muted' : ''}">
                                <input type="checkbox" class="slot-checkbox" 
                                       name="time" id="${id}" 
                                       value="${slot.id}" 
                                       ${isBooked ? 'disabled' : ''}> 
                                ${slot.time} ${isBooked ? '(Booked)' : ''}
                            </label>`;
                    });
                    html += `</div>`;
                }
            });


            if (!hasSlots) {
                html = '<p class="text-danger">No available slots for the selected date.</p>';
            }

            slotContainer.innerHTML = html;

            // enforce only one checkbox at a time
            slotContainer.querySelectorAll('.slot-checkbox').forEach(cb => {
                cb.addEventListener('change', function () {
                    if (this.checked) {
                        slotContainer.querySelectorAll('.slot-checkbox').forEach(other => {
                            if (other !== this) other.checked = false;
                        });
                    }
                });
            });
        })
        .catch(err => {
            slotContainer.innerHTML = '<p class="text-danger">Failed to load slots. Please try again.</p>';
            console.error(err);
        });
    });
});
</script>

<!-- Sandbox -->
<script src="https://sdk.cashfree.com/js/v3/cashfree.js"></script>

<!-- For production later -->
 <!--<script src="https://sdk.cashfree.com/js/v3/cashfree.js"></script>-->



<script>
$(document).ready(function () {

    // --- helpers ---
    function resetForm() {
        $('#inputform')[0].reset();
        $('.form-control').removeClass('is-valid is-invalid');

        // Reset custom dropdowns
        $('#userSearch').val('');
        $('#userSelect').val('').hide();

        $('#hospitalSearch').val('');
        $('#hospitalSelect').val('').hide();

    }

    function validateForm() {
        let isValid = true;
        $('#inputform [required]').each(function () {
            let value = $(this).val();
    
            // Special handling for flatpickr
            if ($(this).attr('id') === 'date' && $(this)[0]._flatpickr) {
                value = $(this)[0]._flatpickr.input.value; 
            }
    
            if (Array.isArray(value)) value = value.join('');
            value = value ? value.toString().trim() : '';
    
            if (value === '') {
                isValid = false;
                $(this).addClass('is-invalid');
                showToast('Error', `${$(this).attr('placeholder')} is required`, 'error');
                return false;
            }
            $(this).removeClass('is-invalid').addClass('is-valid');
        });
        return isValid;
    }


    // --- subscription check ---
    function checkUserSubscription(user_id, callback) {
        $.ajax({
            url: '<?= base_url("admin/register/check_user_subscription/"); ?>' + user_id,
            type: 'POST',
            dataType: 'json',
            success: function (res) {
                if (res.success) {
                    showToast('Success', res.message, 'success');
    
                    // ✅ Enable all fields except user inputs
                    $("#inputform :input").not('#userSearch, #userSelect').prop("disabled", false);
    
                    // --- populate family members dropdown ---
                    let familySelect = $("select[name='family_member_id']");
                    familySelect.empty();
                    familySelect.append('<option value="">Select Family Member</option>');
    
                    if (res.family_members && res.family_members.length > 0) {
                        res.family_members.forEach(function (member) {
                            familySelect.append(
                                `<option value="${member.id}">
                                    ${member.name} (${member.mobile || ''})
                                 </option>`
                            );
                        });
                    } else {
                        familySelect.append('<option value="">No Family Members Found</option>');
                    }
    
                } else {
                    showToast('Error', res.message, 'error');
    
                    // ❌ Disable all fields except user inputs
                    $("#inputform :input").not('#userSearch, #userSelect').prop("disabled", true);
    
                    $('#address_display, #address_hidden, #address_lat, #address_lon').val('');
    
                    let familySelect = $("select[name='family_member_id']");
                    familySelect.empty().append('<option value="">Select Family Member</option>');
                }
    
                if (callback) callback(res.success);
            },
            error: function () {
                showToast('Error', 'An unexpected error occurred.', 'error');
    
                // ❌ Disable all fields except user inputs
                $("#inputform :input").not('#userSearch, #userSelect').prop("disabled", true);
    
                if (callback) callback(false);
            }
        });
    }

    
    function getSpecialities(hospital_id, callback) {
        $.ajax({
            url: '<?= base_url("admin/register/get_hospital_specialities/"); ?>' + hospital_id,
            type: 'POST',
            dataType: 'json',
            success: function (res) {
                if (res.success) {
                    //showToast('Success', res.message, 'success');
                    $("#inputform :input").prop("disabled", false);
    
                    // --- populate family members dropdown ---
                    let specialitySelect = $("select[name='speciality_id']");
                    specialitySelect.empty(); // clear old options
                    specialitySelect.append('<option value="">Select Speciality</option>');
    
                    if (res.specialities && res.specialities.length > 0) {
                        res.specialities.forEach(function (spec) {
                            specialitySelect.append(
                                `<option value="${spec.speciality_id}">
                                    ${spec.name}
                                 </option>`
                            );
                        });
                    } else {
                        specialitySelect.append('<option value="">No Specialities Found</option>');
                    }
                    
    
                } else {
                    showToast('Error', res.message, 'error');

                    // Reset family members dropdown
                    let specialitySelect = $("select[name='speciality_id']");
                    specialitySelect.empty().append('<option value="">Select Speciality</option>');
                    
                }
    
                if (callback) callback(res.success);
            },
            error: function () {
                showToast('Error', 'An unexpected error occurred.', 'error');
                if (callback) callback(false);
            }
        });
    }
    
    function getDoctors(hospital_id, speciality_id, callback) {
        $.ajax({
            url: '<?= base_url("admin/register/get_hospital_online_doctors/"); ?>' + hospital_id + '/' + speciality_id,
            type: 'POST',
            dataType: 'json',
            success: function (res) {
                if (res.success) {
                    $("#inputform :input").prop("disabled", false);
    
                    let doctorSelect = $("select[name='doctor_id']");
                    doctorSelect.empty();
                    doctorSelect.append('<option value="">Select Doctor</option>');
    
                    if (res.doctors && res.doctors.length > 0) {
                        res.doctors.forEach(function (doc) {
                            doctorSelect.append(
                                `<option value="${doc.id}">${doc.name}</option>`
                            );
                        });
                    } else {
                        doctorSelect.append('<option value="">No Doctors Found</option>');
                    }
    
                    $('#fee').val('0');
                    $('#consultation_fee').val('0');
    
                    let container = $("#couponContainer");
                    container.empty();
                    container.html('<p class="text-danger">No coupons available</p>');
    
                    // ✅ Destroy old Flatpickr instance and reset value
                    if ($("#date")[0]._flatpickr) {
                        $("#date")[0]._flatpickr.destroy();
                    }
                    $('#date').val('');
    
                } else {
                    showToast('Error', res.message, 'error');
    
                    let doctorSelect = $("select[name='doctor_id']");
                    doctorSelect.empty().append('<option value="">Select Doctor</option>');
    
                    $('#fee').val('0');
                    $('#consultation_fee').val('0');
    
                    let container = $("#couponContainer");
                    container.empty();
                    container.html('<p class="text-danger">No coupons available</p>');
    
                    // ✅ Destroy old Flatpickr instance and reset value
                    if ($("#date")[0]._flatpickr) {
                        $("#date")[0]._flatpickr.destroy();
                    }
                    $('#date').val('');
                }
    
                if (callback) callback(res.success);
            },
            error: function () {
                showToast('Error', 'An unexpected error occurred.', 'error');
                if (callback) callback(false);
            }
        });
    }

    
    function getDoctordates(hospital_id, doctor_id) {
    $.ajax({
        url: '<?= base_url("admin/register/get_hospital_online_doctor_dates/"); ?>' + hospital_id + '/' + doctor_id,
        type: 'POST',
        dataType: 'json',
        success: function (res) {
            if (res.success && res.dates.length > 0) {
                // Extract Y-m-d format dates from backend response
                let enabledDates = res.dates.map(d => d.date);

                // Initialize Flatpickr
                flatpickr("#date", {
                    dateFormat: "Y-m-d",     // value stored in DB (hidden format)
                    altInput: true,
                    altFormat: "D d M Y",   // pretty UI format e.g. Thu 11 Sep 2025
                    minDate: "today",
                    enable: enabledDates    // âœ… only allow doctorâ€™s available dates
                });
                
                $('#fee').val(res.dates[0].offline_fee);
                $('#consultation_fee').val(res.dates[0].offline_fee);
                loadCoupons();
            } else {
                showToast('Error', 'No available dates found', 'error');
                document.getElementById("date").value = "";
            }
        },
        error: function () {
            showToast('Error', 'Failed to load doctor dates', 'error');
        }
    });
}

    function loadCoupons() {
        let fee_val =  $('#fee').val();
        if (fee_val != 0) {
            $.ajax({
                url: '<?= base_url("admin/register/get_doctor_coupons"); ?>',
                type: 'POST',
                dataType: 'json',
                success: function (res) {
                    let container = $("#couponContainer");
                    container.empty();
        
                    if (res.success && res.coupons && res.coupons.length > 0) {
                        // Save original fee for reference
                        window.originalConsultationFee = Math.round(parseFloat($("#fee").val()) || 0);
        
                        // Clear hidden coupon fields
                        $('#applied_coupon_id,#applied_coupon_code,#applied_coupon_discount,#applied_coupon_amount').val('');
        
                        // Render coupon cards
                        res.coupons.forEach(coupon => {
                            const id = coupon.id || '';
                            const code = coupon.code || coupon.name || '';
                            const percentage = coupon.percentage || coupon.discount || 0;
                            const description = coupon.description || '';
        
                            container.append(`
                                <div class="card mb-2 border">
                                  <div class="card-body p-2">
                                    <h6 class="mb-1">${coupon.name}</h6>
                                    <p class="small mb-1">${description}</p>
                                    <div class="d-flex justify-content-between align-items-center">
                                      <span class="badge bg-danger">${code}</span>
                                      <button type="button" class="btn btn-sm btn-outline-primary applyCouponBtn"
                                              data-id="${id}"
                                              data-code="${code}"
                                              data-discount="${percentage}">
                                        APPLY
                                      </button>
                                    </div>
                                  </div>
                                </div>
                            `);
                        });
        
                        // Bind coupon apply/unapply
                        $(document).off('click', '.applyCouponBtn').on('click', '.applyCouponBtn', function () {
                            const btn = $(this);
                            const couponId = btn.data('id').toString();
                            const code = btn.data('code').toString();
                            const discount = parseFloat(btn.data('discount')) || 0;
                            const original = Math.round(parseFloat(window.originalConsultationFee) || 0);
        
                            // If same coupon clicked again → unapply
                            if ($('#applied_coupon_id').val() === couponId) {
                                $('#consultation_fee').val(original);
        
                                $('#applied_coupon_id').val('');
                                $('#applied_coupon_code').val('');
                                $('#applied_coupon_discount').val('');
                                $('#applied_coupon_amount').val('');
        
                                btn.text('APPLY').removeClass('btn-success').addClass('btn-outline-primary');
        
                                showToast('Info', `Coupon ${code} removed.`, 'info');
                                return;
                            }
        
                            // Reset all buttons to default
                            $('.applyCouponBtn').text('APPLY').removeClass('btn-success').addClass('btn-outline-primary');
        
                            // Apply new coupon
                            const discountAmount = Math.round(original * discount / 100);
                            const newTotal = original - discountAmount;
        
                            $('#consultation_fee').val(newTotal);
        
                            $('#applied_coupon_id').val(couponId);
                            $('#applied_coupon_code').val(code);
                            $('#applied_coupon_discount').val(discount);
                            $('#applied_coupon_amount').val(discountAmount);
        
                            btn.text('APPLIED').removeClass('btn-outline-primary').addClass('btn-success');
        
                            showToast('Success', `Coupon ${code} applied. You saved ₹${discountAmount}!`, 'success');
                        });
        
                    } else {
                        container.html('<p class="text-danger">No coupons available</p>');
                    }
                },
                error: function () {
                    $("#couponContainer").html('<p class="text-danger">Failed to load coupons</p>');
                }
            });
        }
    }

    // --- events ---
    $('#userSelect').on('change', function () {
        let user_id = $(this).val();
        if (user_id) checkUserSubscription(user_id);
    });
    
    $('#hospitalSelect').on('change', function () {
        let hospital_id = $(this).val();
        if (hospital_id) getSpecialities(hospital_id);
    });
    
    $('#speciality_id').on('change', function () {
        let speciality_id = $(this).val();
        let hospital_id = $('#hospitalSelect').val();
        if (speciality_id) getDoctors(hospital_id,speciality_id);
    });
    
    $('#doctor_id').on('change', function () {
        let doctor_id = $(this).val();
        let hospital_id = $('#hospitalSelect').val();
        if (doctor_id) {
            getDoctordates(hospital_id, doctor_id);
        }
    });

    $('#saveBtn').on('click', function () {
        if (!validateForm()) return;
    
        const form = $('#inputform')[0];
        const formData = new FormData(form);
    
        $.ajax({
            url: '<?= base_url("admin/register/create_hospital_online_doctor_cashfree_order"); ?>',
            type: 'POST',
            data: formData,
            contentType: false,
            processData: false,
            success: function (response) {
                let res = {};
                try {
                    res = JSON.parse(response);
                } catch (e) {
                    showToast('Error', 'Invalid response from server', 'error');
                    return;
                }
    
                // ✅ Handle slot not selected
                if (res.success === false) {
                    showToast('Error', res.message, 'error');
                    return;
                }
    
                // ✅ Normal Cashfree checkout
                if (res.payment_session_id) {
                    const cashfree = Cashfree({
                        mode: "sandbox" // or "production" or "sandbox"
                    });
    
                    cashfree.checkout({
                        paymentSessionId: res.payment_session_id,
                        redirectTarget: "_self"
                    });
                } else {
                    showToast('Error', 'Failed to create order', 'error');
                }
            },
            error: function () {
                showToast('Error', 'An unexpected error occurred.', 'error');
            }
        });
    });



    // real-time input validation
    $('#inputform .form-control').on('input change', function () {
        if ($(this).val().trim()) {
            $(this).removeClass('is-invalid').addClass('is-valid');
        } else {
            $(this).removeClass('is-valid').addClass('is-invalid');
        }
    });

});
</script>

<script>
    function filterUsers() {
      var input = document.getElementById("userSearch").value.toLowerCase();
      var select = document.getElementById("userSelect");
      var options = select.options;
      var found = false;
    
      for (var i = 0; i < options.length; i++) {
        var txt = options[i].text.toLowerCase();
        if (txt.includes(input)) {
          options[i].style.display = "";
          found = true;
        } else {
          options[i].style.display = "none";
        }
      }
    
      // Show dropdown only if search text is not empty
      select.style.display = input.length > 0 && found ? "block" : "none";
    }
</script>

<script>
    function filterHospitals() {
      var input = document.getElementById("hospitalSearch").value.toLowerCase();
      var select = document.getElementById("hospitalSelect");
      var options = select.options;
      var found = false;
    
      for (var i = 0; i < options.length; i++) {
        var txt = options[i].text.toLowerCase();
        if (txt.includes(input)) {
          options[i].style.display = "";
          found = true;
        } else {
          options[i].style.display = "none";
        }
      }
    
      // Show dropdown only if search text is not empty and a match is found
      select.style.display = input.length > 0 && found ? "block" : "none";
    }
</script>

<!-- Toastr CSS -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
<!-- Toastr JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>


<script>
// Show toast using jQuery
function showToast(title, message, type) {
    toastr.options = {
        closeButton: true,
        progressBar: true,
        positionClass: "toast-top-right",
        timeOut: "3000",
    };

    if (type === 'success') {
        toastr.success(message, title);
    } else if (type === 'error') {
        toastr.error(message, title);
    } else if (type === 'info') {
        toastr.info(message, title);
    } else if (type === 'warning') {
        toastr.warning(message, title);
    }
}


</script>

<?php if($this->session->flashdata('success')): ?>
    <script>
        showToast('Success', "<?= $this->session->flashdata('success') ?>", 'success');
        
    </script>
<?php endif; ?>

<?php if($this->session->flashdata('error')): ?>
    <script>
        showToast('Error', '<?= $this->session->flashdata('error') ?>', 'error');
    </script>
<?php endif; ?>