<div class="container-xxl flex-grow-1 container-p-y">
              <h4 class="py-3 mb-4"><span class="text-muted fw-light">Ambulance Booking</h4>
              
  <div class="row"><div class="col-md-6">
      <div class="card mb-4">
          <form method="post" action="#" id="inputform" enctype="multipart/form-data">
        <div class="card-body">
            

          <div class="mb-3">
            <label for="userSearch" class="form-label">Users *</label>
        
            <!-- Search box -->
            <input type="text" id="userSearch" class="form-control user-search" placeholder="Type name, mobile, or unique ID" onkeyup="filterUsers()">
        
            <!-- Dropdown -->
            <select id="userSelect" name="user_id" class="form-select mt-2 user-select" size="5" required placeholder="User">
                <?php if(!empty($users)){ 
                        foreach($users as $row){ ?>
                            <option value="<?= $row['id'] ?>"><?= $row['name'] ?> (<?= $row['mobile'] ?>) (<?= $row['unique_id'] ?>)</option>
                    <?php } } ?>
            </select>
        </div>
        
          <div class="mb-3">
            <label for="exampleFormControlInput1" class="form-label">Address *</label>
            <!-- Visible input -->
            <textarea
                class="form-control"
                id="address_display"
                placeholder="Address"
                name="address_display"
                readonly required>
            </textarea>
            
            <!-- Hidden input to submit actual address -->
            <input type="hidden" name="address" id="address_hidden" />
            
            <!-- Hidden input to lat -->
            <input type="hidden" name="lat" id="address_lat" />
            
            <!-- Hidden input to lon -->
            <input type="hidden" name="lon" id="address_lon" />

          </div>
          
          <div class="mb-3">
            <label for="stateSearch" class="form-label">States *</label>
        
            <!-- Search box -->
            <input type="text" id="stateSearch" class="form-control state-search" placeholder="Type state name" onkeyup="filterStates()">
        
            <!-- Dropdown -->
            <select id="stateSelect" name="state_id" class="form-select mt-2 state-select" size="5">
                <option value="" disabled selected>Select State</option>
                <?php if(!empty($states)){ 
                    foreach($states as $row){ ?>
                        <option value="<?= $row['id'] ?>"><?= $row['name'] ?></option>
                <?php } } ?>
            </select>
        </div>

          
          <div class="mb-3">
            <label for="district_id" class="form-label">Districts *</label>
            
            <!-- Search box -->
            <input type="text" id="districtSearch" class="form-control district-search" placeholder="Type district name" onkeyup="filterDistricts()">
        
            <!-- Dropdown (will be populated via JS) -->
            <select id="district_id" name="district_id" class="form-select mt-2 district-select" size="5" style="display:none;" >
                <option value="">Select District</option>
            </select>
        </div>

          
          <div class="mb-3">
            <label for="city_id" class="form-label">Cities *</label>
            
            <!-- Search box -->
            <input type="text" id="citySearch" class="form-control city-search" placeholder="Type city name" onkeyup="filterCities()">
        
            <!-- Dropdown (populated dynamically) -->
            <select class="form-select mt-2 city-select" name="city_id" id="city_id" placeholder="City" size="5" style="display:none;" >
                <option value="">Select City</option>
            </select>
        </div>

            
            <div class="mb-3">
                <label for="hospitalSearch" class="form-label">Hospitals *</label>
            
                <!-- Search box -->
                <input type="text" id="hospitalSearch" class="form-control" placeholder="Type hospital name, mobile, or location" onkeyup="filterHospitals()">
            
                <!-- Dropdown -->
                <select id="hospitalSelect" name="main_data_id" class="form-select mt-2 hospital-select" size="5" style="display:none;" required placeholder="Hospital">
                </select>
            </div>

        
        </div>
      </div>
       <button type="button" name="sub" value="sub" class="btn btn-success" id="saveBtn">Submit</button>
      </form>
      <!--<a href="<?=base_url('admin/register/hospital_notifications')?>"><button type="button" class="btn btn-danger">Cancel</button></a>-->
    </div></div>
</div>

<style>
    /* Hospital Search Input */
#hospitalSearch {
    border: 2px solid #007bff;
    border-radius: 8px;
    padding: 10px 12px;
    font-size: 15px;
    transition: all 0.3s ease;
}

#hospitalSearch:focus {
    border-color: #0056b3;
    box-shadow: 0 0 6px rgba(0, 123, 255, 0.5);
    outline: none;
}

/* Hospital Dropdown */
.hospital-select {
    border: 1.5px solid #ddd;
    border-radius: 8px;
    padding: 6px;
    font-size: 14px;
    color: #333;
    background: #fff;
    box-shadow: 0 2px 6px rgba(0,0,0,0.05);
    max-height: 220px; /* prevents very long list */
    overflow-y: auto;
}

/* Dropdown options */
.hospital-select option {
    padding: 10px;
    font-size: 14px;
    line-height: 1.4;
    white-space: normal;   /* allow wrapping */
    word-wrap: break-word;
    border-bottom: 1px solid #f0f0f0;
}

/* Highlight on hover */
.hospital-select option:hover,
.hospital-select option:focus {
    background: #f1f9ff;
    color: #007bff;
}

/* First option when no results */
.hospital-select option[value=""] {
    color: #888;
    font-style: italic;
}

/* User Search Input */
.user-search {
    border: 2px solid #28a745;
    border-radius: 8px;
    padding: 10px 12px;
    font-size: 15px;
    transition: all 0.3s ease;
}

.user-search:focus {
    border-color: #1e7e34;
    box-shadow: 0 0 6px rgba(40, 167, 69, 0.4);
    outline: none;
}

/* User Dropdown */
.user-select {
    border: 1.5px solid #ddd;
    border-radius: 8px;
    padding: 6px;
    font-size: 14px;
    color: #333;
    background: #fff;
    box-shadow: 0 2px 6px rgba(0,0,0,0.05);
    max-height: 220px; /* limit list height */
    overflow-y: auto;
}

/* Dropdown options */
.user-select option {
    padding: 10px;
    font-size: 14px;
    line-height: 1.4;
    white-space: normal;   /* allow wrapping */
    word-wrap: break-word;
    border-bottom: 1px solid #f5f5f5;
}

/* Hover / Focus effect */
.user-select option:hover,
.user-select option:focus {
    background: #e6f9ee;
    color: #28a745;
}

/* First option if no users */
.user-select option[value=""] {
    color: #888;
    font-style: italic;
}

/* State Search Input */
.state-search {
    border: 2px solid #007bff;
    border-radius: 8px;
    padding: 10px 12px;
    font-size: 15px;
    transition: all 0.3s ease;
}

.state-search:focus {
    border-color: #0056b3;
    box-shadow: 0 0 6px rgba(0, 123, 255, 0.4);
    outline: none;
}

/* State Dropdown */
.state-select {
    border: 1.5px solid #ddd;
    border-radius: 8px;
    padding: 6px;
    font-size: 14px;
    color: #333;
    background: #fff;
    box-shadow: 0 2px 6px rgba(0,0,0,0.05);
    max-height: 220px; /* limit list height */
    overflow-y: auto;
}

/* Dropdown options */
.state-select option {
    padding: 10px;
    font-size: 14px;
    line-height: 1.4;
    white-space: normal;   /* allow wrapping */
    word-wrap: break-word;
    border-bottom: 1px solid #f5f5f5;
}

/* Hover / Focus effect */
.state-select option:hover,
.state-select option:focus {
    background: #e6f2ff;
    color: #007bff;
}

/* Disabled placeholder option */
.state-select option[value=""] {
    color: #888;
    font-style: italic;
}


/* District Search Input */
.district-search {
    border: 2px solid #fd7e14;   /* orange */
    border-radius: 8px;
    padding: 10px 12px;
    font-size: 15px;
    transition: all 0.3s ease;
}

.district-search:focus {
    border-color: #e8590c;
    box-shadow: 0 0 6px rgba(253, 126, 20, 0.4);
    outline: none;
}

/* District Dropdown */
.district-select {
    border: 1.5px solid #ddd;
    border-radius: 8px;
    padding: 6px;
    font-size: 14px;
    color: #333;
    background: #fff;
    box-shadow: 0 2px 6px rgba(0,0,0,0.05);
    max-height: 220px;
    overflow-y: auto;
}

/* Dropdown options */
.district-select option {
    padding: 10px;
    font-size: 14px;
    line-height: 1.4;
    white-space: normal;
    word-wrap: break-word;
    border-bottom: 1px solid #f5f5f5;
}

/* Hover / Focus */
.district-select option:hover,
.district-select option:focus {
    background: #fff4e6;
    color: #fd7e14;
}

/* Placeholder option */
.district-select option[value=""] {
    color: #888;
    font-style: italic;
}

/* City Search Input */
.city-search {
    border: 2px solid #20c997;   /* teal */
    border-radius: 8px;
    padding: 10px 12px;
    font-size: 15px;
    transition: all 0.3s ease;
}

.city-search:focus {
    border-color: #0ca678;
    box-shadow: 0 0 6px rgba(32, 201, 151, 0.4);
    outline: none;
}

/* City Dropdown */
.city-select {
    border: 1.5px solid #ddd;
    border-radius: 8px;
    padding: 6px;
    font-size: 14px;
    color: #333;
    background: #fff;
    box-shadow: 0 2px 6px rgba(0,0,0,0.05);
    max-height: 220px;
    overflow-y: auto;
}

/* Dropdown options */
.city-select option {
    padding: 10px;
    font-size: 14px;
    line-height: 1.4;
    white-space: normal;
    word-wrap: break-word;
    border-bottom: 1px solid #f5f5f5;
}

/* Hover / Focus */
.city-select option:hover,
.city-select option:focus {
    background: #e6fcf5;
    color: #0ca678;
}

/* Placeholder option */
.city-select option[value=""] {
    color: #888;
    font-style: italic;
}
</style>

<script>
$(document).ready(function () {

    // --- helpers ---
    function resetForm() {
        $('#inputform')[0].reset();
        $('.form-control').removeClass('is-valid is-invalid');

        // Reset custom dropdowns
        $('#userSearch').val('');
        $('#userSelect').val('').hide();

        $('#hospitalSearch').val('');
        $('#hospitalSelect').val('').hide();

        // Clear hidden fields
        $('#address_display').val('');
        $('#address_hidden').val('');
        $('#address_lat').val('');
        $('#address_lon').val('');
    }

    function validateForm() {
        let isValid = true;
        $('#inputform [required]').each(function () {
            let value = $(this).val();
            if (Array.isArray(value)) value = value.join('');
            value = value ? value.toString().trim() : '';

            if (value === '') {
                isValid = false;
                $(this).addClass('is-invalid');
                showToast('Error', `${$(this).attr('placeholder')} is required`, 'error');
                return false; // break each()
            }
            $(this).removeClass('is-invalid').addClass('is-valid');
        });
        return isValid;
    }

    // --- subscription check ---
    function checkUserSubscription(user_id, callback) {
        $.ajax({
            url: '<?= base_url("admin/register/check_user_subscription/"); ?>' + user_id,
            type: 'POST',
            dataType: 'json',
            success: function (res) {
                if (res.success) {
                    showToast('Success', res.message, 'success');
    
                    // ✅ Enable all except user fields
                    $("#inputform :input").not('#userSearch, #userSelect').prop("disabled", false);
    
                    // Populate address if subscription is valid
                    $('#address_display').val(res.address);
                    $('#address_hidden').val(res.address_id);
                    $('#address_lat').val(res.lat);
                    $('#address_lon').val(res.lon);
    
                } else {
                    showToast('Error', res.message, 'error');
    
                    // ❌ Disable all except user fields
                    $("#inputform :input").not('#userSearch, #userSelect').prop("disabled", true);
    
                    // Clear address
                    $('#address_display, #address_hidden, #address_lat, #address_lon').val('');
                }
                if (callback) callback(res.success);
            },
            error: function () {
                showToast('Error', 'An unexpected error occurred.', 'error');
    
                // ❌ Disable all except user fields
                $("#inputform :input").not('#userSearch, #userSelect').prop("disabled", true);
    
                if (callback) callback(false);
            }
        });
    }
    
    // --- hospitals check ---
    function getHospitals(state_id, district_id = '', city_id = '', callback) {
        $.ajax({
            url: '<?= base_url("admin/register/get_hospitals_data"); ?>',
            type: 'POST',
            dataType: 'json',
            data: {
                state_id: state_id,
                district_id: district_id,
                city_id: city_id
            },
            success: function (res) {
                let hospitalSelect = $("#hospitalSelect");
                hospitalSelect.empty();
    
                if (res.success && res.hospitals.length > 0) {
                    res.hospitals.forEach(function (hos) {
                        $("#hospitalSelect").append(
                            `<option value="${hos.id}">
                                ${hos.name} (${hos.mobile}) - ${hos.address}
                            </option>`
                        );
                    });

                    hospitalSelect.show();
                } else {
                    hospitalSelect.append('<option value="">No Hospitals Found</option>').show();
                }
    
                if (callback) callback(res.success);
            },
            error: function () {
                showToast('Error', 'Failed to load hospitals', 'error');
                if (callback) callback(false);
            }
        });
    }

    
    // --- districts check ---
    function getDistricts(state_id, callback) {
        $.ajax({
            url: '<?= base_url("admin/register/get_districts_data/"); ?>' + state_id,
            type: 'POST',
            dataType: 'json',
            success: function (res) {
                if (res.success) {
                    showToast('Success', res.message, 'success');
                    let districtSelectt = $("#district_id");
                    districtSelectt.empty();
    
                    // --- populate family members dropdown ---
                    let districtSelect = $("select[name='district_id']");
                    districtSelect.empty(); // clear old options
                    districtSelect.append('<option value="">Select District</option>');
    
                    if (res.districts && res.districts.length > 0) {
                        res.districts.forEach(function (dis) {
                            districtSelect.append(
                                `<option value="${dis.id}">
                                    ${dis.name}
                                 </option>`
                            );
                        });
                        districtSelectt.show();
                    } else {
                        districtSelect.append('<option value="">No District Found</option>');
                    }
    
                } else {
                    showToast('Error', res.message, 'error');
                
                    // Reset family members dropdown
                    let districtSelect = $("select[name='district_id']");
                    districtSelect.empty().append('<option value="">Select District</option>');
                }
    
                if (callback) callback(res.success);
            },
            error: function () {
                showToast('Error', 'An unexpected error occurred.', 'error');
    
                if (callback) callback(false);
            }
        });
    }
    
    // --- cities check ---
    function getCities(state_id,district_id, callback) {
        $.ajax({
            url: '<?= base_url("admin/register/get_cities_data/"); ?>' + state_id + '/'+ district_id,
            type: 'POST',
            dataType: 'json',
            success: function (res) {
                if (res.success) {
                    showToast('Success', res.message, 'success');
                    
                    let cityySelectt = $("#city_id");
                    cityySelectt.empty();
    
                    // --- populate family members dropdown ---
                    let citySelect = $("select[name='city_id']");
                    citySelect.empty(); // clear old options
                    citySelect.append('<option value="">Select City</option>');
    
                    if (res.cities && res.cities.length > 0) {
                        res.cities.forEach(function (city) {
                            citySelect.append(
                                `<option value="${city.id}">
                                    ${city.name}
                                 </option>`
                            );
                        });
                        cityySelectt.show();
                    } else {
                        districtSelect.append('<option value="">No City Found</option>');
                    }
    
                } else {
                    showToast('Error', res.message, 'error');
                
                    // Reset family members dropdown
                    let citySelect = $("select[name='city_id']");
                    //districtSelect.empty().append('<option value="">Select District</option>');
                }
    
                if (callback) callback(res.success);
            },
            error: function () {
                showToast('Error', 'An unexpected error occurred.', 'error');
    
                if (callback) callback(false);
            }
        });
    }

    // --- distance check ---
    function checkUserDistance(user_id, hospital_id, lat, lon, callback) {
        $.ajax({
            url: '<?= base_url("admin/register/check_user_distance/"); ?>',
            type: 'POST',
            data: { user_id, hospital_id, lat, lon },
            dataType: 'json',
            success: function (res) {
                if (res.success) {
                    showToast('Success', res.message, 'success');
                } else {
                    showToast('Error', res.message, 'error');
                }
                if (callback) callback(res.success);
            },
            error: function () {
                showToast('Error', 'An unexpected error occurred.', 'error');
                if (callback) callback(false);
            }
        });
    }

    // --- events ---
    $('#userSelect').on('change', function () {
        let user_id = $(this).val();
        if (user_id) checkUserSubscription(user_id);
    });
    
    $('#stateSelect').on('change', function () {
        let state_id = $(this).val();
        if (state_id) {
            getDistricts(state_id);
            getHospitals(state_id); // load hospitals by state
        }
    });

    $('#district_id').on('change', function () {
        let state_id = $('#stateSelect').val();
        let district_id = $(this).val();
        if (state_id && district_id) {
            getCities(state_id, district_id);
            getHospitals(state_id, district_id); // load hospitals by state + district
        }
    });

    $('#city_id').on('change', function () {
        let state_id = $('#stateSelect').val();
        let district_id = $('#district_id').val();
        let city_id = $(this).val();
        if (state_id && district_id && city_id) {
            getHospitals(state_id, district_id, city_id); // load hospitals by state + district + city
        }
    });

    $('#hospitalSelect').on('change', function () {
        let user_id = $('#userSelect').val();
        let hospital_id = $(this).val();
        let address_id = $('#address_hidden').val();
        let lat = $('#address_lat').val();
        let lon = $('#address_lon').val();

        if (!user_id || !hospital_id) return;
        if (!address_id) {
            showToast('Error', 'Address cannot be empty', 'error');
            return;
        }
        checkUserDistance(user_id, hospital_id, lat, lon);
    });

    $('#saveBtn').on('click', function () {
        if (!validateForm()) {
            $('html, body').animate({
                scrollTop: $('.is-invalid:first').offset().top - 100
            }, 500);
            return;
        }
    
        let user_id     = $('#userSelect').val();
        let hospital_id = $('#hospitalSelect').val();
        let address_id  = $('#address_hidden').val();
        let lat         = $('#address_lat').val();
        let lon         = $('#address_lon').val();
    
        if (!address_id) {
            showToast('Error', 'Address cannot be empty', 'error');
            return;
        }
    
        // ✅ Step 1: check subscription
        checkUserSubscription(user_id, function (subscribed) {
            if (!subscribed) {
                // ❌ stop flow if no subscription
                showToast('Error', 'User does not have an active subscription', 'error');
                return;
            }
    
            // ✅ Step 2: check distance
            checkUserDistance(user_id, hospital_id, lat, lon, function (ok) {
                if (!ok) return;
    
                // ✅ Step 3: save booking
                const form = $('#inputform')[0];
                const formData = new FormData(form);
    
                $.ajax({
                    url: '<?= base_url("admin/register/insert_ambulance_booking"); ?>',
                    type: 'POST',
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: function (response) {
                        const res = JSON.parse(response);
                        if (res.success) {
                            showToast('Success', res.message, 'success');
                            resetForm();
                        } else {
                            showToast('Error', res.message, 'error');
                        }
                    },
                    error: function () {
                        showToast('Error', 'An unexpected error occurred.', 'error');
                    }
                });
            });
        });
    });


    // real-time input validation
    $('#inputform .form-control').on('input change', function () {
        if ($(this).val().trim()) {
            $(this).removeClass('is-invalid').addClass('is-valid');
        } else {
            $(this).removeClass('is-valid').addClass('is-invalid');
        }
    });

});
</script>

<script>
    function filterUsers() {
      var input = document.getElementById("userSearch").value.toLowerCase();
      var select = document.getElementById("userSelect");
      var options = select.options;
      var found = false;
    
      for (var i = 0; i < options.length; i++) {
        var txt = options[i].text.toLowerCase();
        if (txt.includes(input)) {
          options[i].style.display = "";
          found = true;
        } else {
          options[i].style.display = "none";
        }
      }
    
      // Show dropdown only if search text is not empty
      select.style.display = input.length > 0 && found ? "block" : "none";
    }
</script>

<script>
    function filterStates() {
      var input = document.getElementById("stateSearch").value.toLowerCase();
      var select = document.getElementById("stateSelect");
      var options = select.options;
      var found = false;
    
      for (var i = 0; i < options.length; i++) {
        var txt = options[i].text.toLowerCase();
        if (txt.includes(input)) {
          options[i].style.display = "";
          found = true;
        } else {
          options[i].style.display = "none";
        }
      }
    
      // Show dropdown only if search text is not empty
      select.style.display = input.length > 0 && found ? "block" : "none";
    }
</script>

<script>
    function filterDistricts() {
      var input = document.getElementById("districtSearch").value.toLowerCase();
      var select = document.getElementById("district_id");
      var options = select.options;
      var found = false;
    
      for (var i = 0; i < options.length; i++) {
        var txt = options[i].text.toLowerCase();
        if (txt.includes(input)) {
          options[i].style.display = "";
          found = true;
        } else {
          options[i].style.display = "none";
        }
      }
    
      // Show dropdown only if search text is not empty
      select.style.display = input.length > 0 && found ? "block" : "none";
    }
</script>

<script>
    function filterCities() {
      var input = document.getElementById("citySearch").value.toLowerCase();
      var select = document.getElementById("city_id");
      var options = select.options;
      var found = false;
    
      for (var i = 0; i < options.length; i++) {
        var txt = options[i].text.toLowerCase();
        if (txt.includes(input)) {
          options[i].style.display = "";
          found = true;
        } else {
          options[i].style.display = "none";
        }
      }
    
      // Show dropdown only if search text is not empty
      select.style.display = input.length > 0 && found ? "block" : "none";
    }
</script>

<script>
    function filterHospitals() {
      var input = document.getElementById("hospitalSearch").value.toLowerCase();
      var select = document.getElementById("hospitalSelect");
      var options = select.options;
      var found = false;
    
      for (var i = 0; i < options.length; i++) {
        var txt = options[i].text.toLowerCase();
        if (txt.includes(input)) {
          options[i].style.display = "";
          found = true;
        } else {
          options[i].style.display = "none";
        }
      }
    
      // Show dropdown only if search text is not empty and a match is found
      select.style.display = input.length > 0 && found ? "block" : "none";
    }
</script>

<!-- Toastr CSS -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
<!-- Toastr JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>


<script>
// Show toast using jQuery
function showToast(title, message, type) {
    toastr.options = {
        closeButton: true,
        progressBar: true,
        positionClass: "toast-top-right",
        timeOut: "3000",
    };

    if (type === 'success') {
        toastr.success(message, title);
    } else if (type === 'error') {
        toastr.error(message, title);
    } else if (type === 'info') {
        toastr.info(message, title);
    } else if (type === 'warning') {
        toastr.warning(message, title);
    }
}


</script>
            