<div class="container-xxl flex-grow-1 container-p-y">
              <h4 class="py-3 mb-4"><span class="text-muted fw-light">Admit Booking</h4>
              
  <div class="row"><div class="col-md-6">
      <div class="card mb-4">
          <form method="post" action="#" id="inputform" enctype="multipart/form-data">
        <div class="card-body">
            
            <div class="mb-3">
                <label for="userSearch" class="form-label">Users *</label>
            
                <!-- Search box -->
                <input type="text" id="userSearch" class="form-control user-search" placeholder="Type name, mobile, or unique ID" onkeyup="filterUsers()">
            
                <!-- Dropdown -->
                <select id="userSelect" name="user_id" class="form-select mt-2 user-select" size="5" required placeholder="User">
                    <?php if(!empty($users)){ 
                            foreach($users as $row){ ?>
                                <option value="<?= $row['id'] ?>"><?= $row['name'] ?> (<?= $row['mobile'] ?>) (<?= $row['unique_id'] ?>)</option>
                        <?php } } ?>
                </select>
            </div>
          
          <div class="mb-3">
            <label for="family_member_id" class="form-label">Family Members *</label>
            
            <select class="form-select family-single-select" 
                    name="family_member_id" 
                    required 
                    id="family_member_id" 
                    placeholder="Family Member">
                <option value="">Select Family Member</option>
            </select>
        </div>
          
            <div class="mb-3">
            <label for="stateSearch" class="form-label">States *</label>
        
            <!-- Search box -->
            <input type="text" id="stateSearch" class="form-control state-search" placeholder="Type state name" onkeyup="filterStates()">
        
            <!-- Dropdown -->
            <select id="stateSelect" name="state_id" class="form-select mt-2 state-select" size="5">
                <option value="" disabled selected>Select State</option>
                <?php if(!empty($states)){ 
                    foreach($states as $row){ ?>
                        <option value="<?= $row['id'] ?>"><?= $row['name'] ?></option>
                <?php } } ?>
            </select>
        </div>

          
          <div class="mb-3">
            <label for="district_id" class="form-label">Districts *</label>
            
            <!-- Search box -->
            <input type="text" id="districtSearch" class="form-control district-search" placeholder="Type district name" onkeyup="filterDistricts()">
        
            <!-- Dropdown (will be populated via JS) -->
            <select id="district_id" name="district_id" class="form-select mt-2 district-select" size="5" style="display:none;" >
                <option value="">Select District</option>
            </select>
        </div>

          
          <div class="mb-3">
            <label for="city_id" class="form-label">Cities *</label>
            
            <!-- Search box -->
            <input type="text" id="citySearch" class="form-control city-search" placeholder="Type city name" onkeyup="filterCities()">
        
            <!-- Dropdown (populated dynamically) -->
            <select class="form-select mt-2 city-select" name="city_id" id="city_id" placeholder="City" size="5" style="display:none;" >
                <option value="">Select City</option>
            </select>
        </div>

            
            <div class="mb-3">
                <label for="hospitalSearch" class="form-label">Hospitals *</label>
            
                <!-- Search box -->
                <input type="text" id="hospitalSearch" class="form-control" placeholder="Type hospital name, mobile, or location" onkeyup="filterHospitals()">
            
                <!-- Dropdown -->
                <select id="hospitalSelect" name="main_data_id" class="form-select mt-2 hospital-select" size="5" style="display:none;" required placeholder="Hospital">
                </select>
            </div>
            
            <div class="mb-3">
              <label for="dateInput" class="form-label">Date *</label>
              <input
                type="date"
                class="form-control"
                id="dateInput"
                name="date"
                placeholder="Date"
                required />
            </div>
            
            <div class="mb-3">
                <label for="exampleFormControlInput1" class="form-label">Time Slots *</label>
                <div id="slotContainer">
                    <p class="text-muted">Please select a date to view available slots.</p>
                </div>
            </div>
        
        </div>
      </div>
       <button type="button" name="sub" value="sub" class="btn btn-success" id="saveBtn">Submit</button>
      </form>
      <!--<a href="<?=base_url('admin/register/hospital_notifications')?>"><button type="button" class="btn btn-danger">Cancel</button></a>-->
    </div></div>
</div>

<style>
    /* Hospital Search Input */
#hospitalSearch {
    border: 2px solid #007bff;
    border-radius: 8px;
    padding: 10px 12px;
    font-size: 15px;
    transition: all 0.3s ease;
}

#hospitalSearch:focus {
    border-color: #0056b3;
    box-shadow: 0 0 6px rgba(0, 123, 255, 0.5);
    outline: none;
}

/* Hospital Dropdown */
.hospital-select {
    border: 1.5px solid #ddd;
    border-radius: 8px;
    padding: 6px;
    font-size: 14px;
    color: #333;
    background: #fff;
    box-shadow: 0 2px 6px rgba(0,0,0,0.05);
    max-height: 220px; /* prevents very long list */
    overflow-y: auto;
}

/* Dropdown options */
.hospital-select option {
    padding: 10px;
    font-size: 14px;
    line-height: 1.4;
    white-space: normal;   /* allow wrapping */
    word-wrap: break-word;
    border-bottom: 1px solid #f0f0f0;
}

/* Highlight on hover */
.hospital-select option:hover,
.hospital-select option:focus {
    background: #f1f9ff;
    color: #007bff;
}

/* First option when no results */
.hospital-select option[value=""] {
    color: #888;
    font-style: italic;
}

/* User Search Input */
.user-search {
    border: 2px solid #28a745;
    border-radius: 8px;
    padding: 10px 12px;
    font-size: 15px;
    transition: all 0.3s ease;
}

.user-search:focus {
    border-color: #1e7e34;
    box-shadow: 0 0 6px rgba(40, 167, 69, 0.4);
    outline: none;
}

/* User Dropdown */
.user-select {
    border: 1.5px solid #ddd;
    border-radius: 8px;
    padding: 6px;
    font-size: 14px;
    color: #333;
    background: #fff;
    box-shadow: 0 2px 6px rgba(0,0,0,0.05);
    max-height: 220px; /* limit list height */
    overflow-y: auto;
}

/* Dropdown options */
.user-select option {
    padding: 10px;
    font-size: 14px;
    line-height: 1.4;
    white-space: normal;   /* allow wrapping */
    word-wrap: break-word;
    border-bottom: 1px solid #f5f5f5;
}

/* Hover / Focus effect */
.user-select option:hover,
.user-select option:focus {
    background: #e6f9ee;
    color: #28a745;
}

/* First option if no users */
.user-select option[value=""] {
    color: #888;
    font-style: italic;
}

/* State Search Input */
.state-search {
    border: 2px solid #007bff;
    border-radius: 8px;
    padding: 10px 12px;
    font-size: 15px;
    transition: all 0.3s ease;
}

.state-search:focus {
    border-color: #0056b3;
    box-shadow: 0 0 6px rgba(0, 123, 255, 0.4);
    outline: none;
}

/* State Dropdown */
.state-select {
    border: 1.5px solid #ddd;
    border-radius: 8px;
    padding: 6px;
    font-size: 14px;
    color: #333;
    background: #fff;
    box-shadow: 0 2px 6px rgba(0,0,0,0.05);
    max-height: 220px; /* limit list height */
    overflow-y: auto;
}

/* Dropdown options */
.state-select option {
    padding: 10px;
    font-size: 14px;
    line-height: 1.4;
    white-space: normal;   /* allow wrapping */
    word-wrap: break-word;
    border-bottom: 1px solid #f5f5f5;
}

/* Hover / Focus effect */
.state-select option:hover,
.state-select option:focus {
    background: #e6f2ff;
    color: #007bff;
}

/* Disabled placeholder option */
.state-select option[value=""] {
    color: #888;
    font-style: italic;
}


/* District Search Input */
.district-search {
    border: 2px solid #fd7e14;   /* orange */
    border-radius: 8px;
    padding: 10px 12px;
    font-size: 15px;
    transition: all 0.3s ease;
}

.district-search:focus {
    border-color: #e8590c;
    box-shadow: 0 0 6px rgba(253, 126, 20, 0.4);
    outline: none;
}

/* District Dropdown */
.district-select {
    border: 1.5px solid #ddd;
    border-radius: 8px;
    padding: 6px;
    font-size: 14px;
    color: #333;
    background: #fff;
    box-shadow: 0 2px 6px rgba(0,0,0,0.05);
    max-height: 220px;
    overflow-y: auto;
}

/* Dropdown options */
.district-select option {
    padding: 10px;
    font-size: 14px;
    line-height: 1.4;
    white-space: normal;
    word-wrap: break-word;
    border-bottom: 1px solid #f5f5f5;
}

/* Hover / Focus */
.district-select option:hover,
.district-select option:focus {
    background: #fff4e6;
    color: #fd7e14;
}

/* Placeholder option */
.district-select option[value=""] {
    color: #888;
    font-style: italic;
}

/* City Search Input */
.city-search {
    border: 2px solid #20c997;   /* teal */
    border-radius: 8px;
    padding: 10px 12px;
    font-size: 15px;
    transition: all 0.3s ease;
}

.city-search:focus {
    border-color: #0ca678;
    box-shadow: 0 0 6px rgba(32, 201, 151, 0.4);
    outline: none;
}

/* City Dropdown */
.city-select {
    border: 1.5px solid #ddd;
    border-radius: 8px;
    padding: 6px;
    font-size: 14px;
    color: #333;
    background: #fff;
    box-shadow: 0 2px 6px rgba(0,0,0,0.05);
    max-height: 220px;
    overflow-y: auto;
}

/* Dropdown options */
.city-select option {
    padding: 10px;
    font-size: 14px;
    line-height: 1.4;
    white-space: normal;
    word-wrap: break-word;
    border-bottom: 1px solid #f5f5f5;
}

/* Hover / Focus */
.city-select option:hover,
.city-select option:focus {
    background: #e6fcf5;
    color: #0ca678;
}

/* Placeholder option */
.city-select option[value=""] {
    color: #888;
    font-style: italic;
}

/* Family Member Single Select */
.family-single-select {
    border: 2px solid #51cf66;   /* green border */
    border-radius: 8px;
    padding: 10px 12px;
    font-size: 14px;
    color: #333;
    background: #fff url("data:image/svg+xml;utf8,<svg fill='%2351cf66' height='24' viewBox='0 0 24 24' width='24' xmlns='http://www.w3.org/2000/svg'><path d='M7 10l5 5 5-5z'/></svg>") no-repeat right 12px center;
    background-size: 18px;
    appearance: none; /* remove default arrow */
    box-shadow: 0 2px 6px rgba(0,0,0,0.05);
    transition: all 0.2s ease;
}

/* Focus effect */
.family-single-select:focus {
    border-color: #2b8a3e;
    box-shadow: 0 0 0 3px rgba(81, 207, 102, 0.25);
    outline: none;
}

/* Option styles */
.family-single-select option {
    padding: 10px;
    font-size: 14px;
}
</style>

<script>
document.getElementById('dateInput').addEventListener('keydown', function(e) {
    e.preventDefault(); // Prevent manual typing
});
</script>

<script>
document.addEventListener("DOMContentLoaded", function () {
    const dateInput = document.getElementById('dateInput');
    const slotContainer = document.getElementById('slotContainer');

    // Set today's date as minimum
    const today = new Date().toISOString().split('T')[0];
    dateInput.setAttribute('min', today);

    dateInput.addEventListener('change', function () {
        const selectedDate = this.value;
        const hospital_id = document.getElementById('hospitalSelect').value; // ðŸ‘ˆ always fetch fresh value

        if (!selectedDate || !hospital_id) {
            slotContainer.innerHTML = '<p class="text-danger">Please select a hospital first.</p>';
            return;
        }

        fetch("<?= base_url('admin/register/get_slots_by_date') ?>", {
            method: "POST",
            headers: { "Content-Type": "application/x-www-form-urlencoded" },
            body: "date=" + encodeURIComponent(selectedDate) + "&hospital_id=" + encodeURIComponent(hospital_id)
        })
        .then(response => response.json())
        .then(slots => {
            let html = '';
            const sections = ['morning', 'afternoon', 'evening'];
            let hasSlots = false;

            sections.forEach(section => {
                if (slots[section] && slots[section].length > 0) {
                    hasSlots = true;
                    html += `<div class="mb-2"><strong>${section.charAt(0).toUpperCase() + section.slice(1)}</strong><br>`;
                    slots[section].forEach((slot, i) => {
                        const id = `${section}_${i}`;
                        html += `
                            <label for="${id}" class="me-2">
                                <input type="checkbox" class="slot-checkbox" required placeholder="Time Slot" name="time" id="${id}" value="${slot.time}"> ${slot.time}
                            </label>`;
                    });
                    html += `</div>`;
                }
            });

            if (!hasSlots) {
                html = '<p class="text-danger">No available slots for the selected date.</p>';
            }

            slotContainer.innerHTML = html;

            // force only one checkbox to be selected
            slotContainer.querySelectorAll('.slot-checkbox').forEach(cb => {
                cb.addEventListener('change', function () {
                    if (this.checked) {
                        slotContainer.querySelectorAll('.slot-checkbox').forEach(other => {
                            if (other !== this) other.checked = false;
                        });
                    }
                });
            });
        })
        .catch(err => {
            slotContainer.innerHTML = '<p class="text-danger">Failed to load slots. Please try again.</p>';
            console.error(err);
        });
    });
});
</script>

<script>
$(document).ready(function () {

    // --- helpers ---
    function resetForm() {
        $('#inputform')[0].reset();
        $('.form-control').removeClass('is-valid is-invalid');

        // Reset custom dropdowns
        $('#userSearch').val('');
        $('#userSelect').val('').hide();

        $('#hospitalSearch').val('');
        $('#hospitalSelect').val('').hide();

    }

    function validateForm() {
        let isValid = true;
        $('#inputform [required]').each(function () {
            let value = $(this).val();
            if (Array.isArray(value)) value = value.join('');
            value = value ? value.toString().trim() : '';

            if (value === '') {
                isValid = false;
                $(this).addClass('is-invalid');
                showToast('Error', `${$(this).attr('placeholder')} is required`, 'error');
                return false; // break each()
            }
            $(this).removeClass('is-invalid').addClass('is-valid');
        });
        return isValid;
    }

    // --- subscription check ---
    function checkUserSubscription(user_id, callback) {
        $.ajax({
            url: '<?= base_url("admin/register/check_user_subscription/"); ?>' + user_id,
            type: 'POST',
            dataType: 'json',
            success: function (res) {
                if (res.success) {
                    showToast('Success', res.message, 'success');
    
                    // ✅ Enable all inputs EXCEPT user selection
                    $("#inputform :input").not('#userSearch, #userSelect').prop("disabled", false);
    
                    // --- populate family members dropdown ---
                    let familySelect = $("select[name='family_member_id']");
                    familySelect.empty(); // clear old options
                    familySelect.append('<option value="">Select Family Member</option>');
    
                    if (res.family_members && res.family_members.length > 0) {
                        res.family_members.forEach(function (member) {
                            familySelect.append(
                                `<option value="${member.id}">
                                    ${member.name} (${member.mobile || ''})
                                 </option>`
                            );
                        });
                    } else {
                        familySelect.append('<option value="">No Family Members Found</option>');
                    }
    
                } else {
                    showToast('Error', res.message, 'error');
                    
                    // ❌ Disable everything EXCEPT user fields
                    $("#inputform :input").not('#userSearch, #userSelect').prop("disabled", true);
    
                    $('#address_display, #address_hidden, #address_lat, #address_lon').val('');
    
                    // Reset family members dropdown
                    let familySelect = $("select[name='family_member_id']");
                    familySelect.empty().append('<option value="">Select Family Member</option>');
                }
    
                if (callback) callback(res.success);
            },
            error: function () {
                showToast('Error', 'An unexpected error occurred.', 'error');
    
                // ❌ Disable everything EXCEPT user fields
                $("#inputform :input").not('#userSearch, #userSelect').prop("disabled", true);
    
                if (callback) callback(false);
            }
        });
    }
    
    // --- hospitals check ---
    function getHospitals(state_id, district_id = '', city_id = '', callback) {
        $.ajax({
            url: '<?= base_url("admin/register/get_hospitals_data"); ?>',
            type: 'POST',
            dataType: 'json',
            data: {
                state_id: state_id,
                district_id: district_id,
                city_id: city_id
            },
            success: function (res) {
                let hospitalSelect = $("#hospitalSelect");
                hospitalSelect.empty();
    
                if (res.success && res.hospitals.length > 0) {
                    res.hospitals.forEach(function (hos) {
                        $("#hospitalSelect").append(
                            `<option value="${hos.id}">
                                ${hos.name} (${hos.mobile}) - ${hos.address}
                            </option>`
                        );
                    });

                    hospitalSelect.show();
                } else {
                    hospitalSelect.append('<option value="">No Hospitals Found</option>').show();
                }
    
                if (callback) callback(res.success);
            },
            error: function () {
                showToast('Error', 'Failed to load hospitals', 'error');
                if (callback) callback(false);
            }
        });
    }

    
    // --- districts check ---
    function getDistricts(state_id, callback) {
        $.ajax({
            url: '<?= base_url("admin/register/get_districts_data/"); ?>' + state_id,
            type: 'POST',
            dataType: 'json',
            success: function (res) {
                if (res.success) {
                    showToast('Success', res.message, 'success');
                    let districtSelectt = $("#district_id");
                    districtSelectt.empty();
    
                    // --- populate family members dropdown ---
                    let districtSelect = $("select[name='district_id']");
                    districtSelect.empty(); // clear old options
                    districtSelect.append('<option value="">Select District</option>');
    
                    if (res.districts && res.districts.length > 0) {
                        res.districts.forEach(function (dis) {
                            districtSelect.append(
                                `<option value="${dis.id}">
                                    ${dis.name}
                                 </option>`
                            );
                        });
                        districtSelectt.show();
                    } else {
                        districtSelect.append('<option value="">No District Found</option>');
                    }
    
                } else {
                    showToast('Error', res.message, 'error');
                
                    // Reset family members dropdown
                    let districtSelect = $("select[name='district_id']");
                    districtSelect.empty().append('<option value="">Select District</option>');
                }
    
                if (callback) callback(res.success);
            },
            error: function () {
                showToast('Error', 'An unexpected error occurred.', 'error');
    
                if (callback) callback(false);
            }
        });
    }
    
    // --- cities check ---
    function getCities(state_id,district_id, callback) {
        $.ajax({
            url: '<?= base_url("admin/register/get_cities_data/"); ?>' + state_id + '/'+ district_id,
            type: 'POST',
            dataType: 'json',
            success: function (res) {
                if (res.success) {
                    showToast('Success', res.message, 'success');
                    
                    let cityySelectt = $("#city_id");
                    cityySelectt.empty();
    
                    // --- populate family members dropdown ---
                    let citySelect = $("select[name='city_id']");
                    citySelect.empty(); // clear old options
                    citySelect.append('<option value="">Select City</option>');
    
                    if (res.cities && res.cities.length > 0) {
                        res.cities.forEach(function (city) {
                            citySelect.append(
                                `<option value="${city.id}">
                                    ${city.name}
                                 </option>`
                            );
                        });
                        cityySelectt.show();
                    } else {
                        districtSelect.append('<option value="">No City Found</option>');
                    }
    
                } else {
                    showToast('Error', res.message, 'error');
                
                    // Reset family members dropdown
                    let citySelect = $("select[name='city_id']");
                    //districtSelect.empty().append('<option value="">Select District</option>');
                }
    
                if (callback) callback(res.success);
            },
            error: function () {
                showToast('Error', 'An unexpected error occurred.', 'error');
    
                if (callback) callback(false);
            }
        });
    }


    // --- events ---
    $('#userSelect').on('change', function () {
        let user_id = $(this).val();
        if (user_id) checkUserSubscription(user_id);
    });
    
    $('#stateSelect').on('change', function () {
        let state_id = $(this).val();
        if (state_id) {
            getDistricts(state_id);
            getHospitals(state_id); // load hospitals by state
        }
    });

    $('#district_id').on('change', function () {
        let state_id = $('#stateSelect').val();
        let district_id = $(this).val();
        if (state_id && district_id) {
            getCities(state_id, district_id);
            getHospitals(state_id, district_id); // load hospitals by state + district
        }
    });

    $('#city_id').on('change', function () {
        let state_id = $('#stateSelect').val();
        let district_id = $('#district_id').val();
        let city_id = $(this).val();
        if (state_id && district_id && city_id) {
            getHospitals(state_id, district_id, city_id); // load hospitals by state + district + city
        }
    });

    $('#saveBtn').on('click', function () {
        if (!validateForm()) {
            $('html, body').animate({
                scrollTop: $('.is-invalid:first').offset().top - 100
            }, 500);
            return;
        }

        const form = $('#inputform')[0];
        const formData = new FormData(form);

        $.ajax({
            url: '<?= base_url("admin/register/insert_admit_booking"); ?>',
            type: 'POST',
            data: formData,
            contentType: false,
            processData: false,
            success: function (response) {
                const res = JSON.parse(response);
                if (res.success) {
                    showToast('Success', res.message, 'success');
                    resetForm();
                } else {
                    showToast('Error', res.message, 'error');
                }
            },
            error: function () {
                showToast('Error', 'An unexpected error occurred.', 'error');
            }
        });
    });

    // real-time input validation
    $('#inputform .form-control').on('input change', function () {
        if ($(this).val().trim()) {
            $(this).removeClass('is-invalid').addClass('is-valid');
        } else {
            $(this).removeClass('is-valid').addClass('is-invalid');
        }
    });

});
</script>

<script>
    function filterUsers() {
      var input = document.getElementById("userSearch").value.toLowerCase();
      var select = document.getElementById("userSelect");
      var options = select.options;
      var found = false;
    
      for (var i = 0; i < options.length; i++) {
        var txt = options[i].text.toLowerCase();
        if (txt.includes(input)) {
          options[i].style.display = "";
          found = true;
        } else {
          options[i].style.display = "none";
        }
      }
    
      // Show dropdown only if search text is not empty
      select.style.display = input.length > 0 && found ? "block" : "none";
    }
</script>

<script>
    function filterStates() {
      var input = document.getElementById("stateSearch").value.toLowerCase();
      var select = document.getElementById("stateSelect");
      var options = select.options;
      var found = false;
    
      for (var i = 0; i < options.length; i++) {
        var txt = options[i].text.toLowerCase();
        if (txt.includes(input)) {
          options[i].style.display = "";
          found = true;
        } else {
          options[i].style.display = "none";
        }
      }
    
      // Show dropdown only if search text is not empty
      select.style.display = input.length > 0 && found ? "block" : "none";
    }
</script>

<script>
    function filterDistricts() {
      var input = document.getElementById("districtSearch").value.toLowerCase();
      var select = document.getElementById("district_id");
      var options = select.options;
      var found = false;
    
      for (var i = 0; i < options.length; i++) {
        var txt = options[i].text.toLowerCase();
        if (txt.includes(input)) {
          options[i].style.display = "";
          found = true;
        } else {
          options[i].style.display = "none";
        }
      }
    
      // Show dropdown only if search text is not empty
      select.style.display = input.length > 0 && found ? "block" : "none";
    }
</script>

<script>
    function filterCities() {
      var input = document.getElementById("citySearch").value.toLowerCase();
      var select = document.getElementById("city_id");
      var options = select.options;
      var found = false;
    
      for (var i = 0; i < options.length; i++) {
        var txt = options[i].text.toLowerCase();
        if (txt.includes(input)) {
          options[i].style.display = "";
          found = true;
        } else {
          options[i].style.display = "none";
        }
      }
    
      // Show dropdown only if search text is not empty
      select.style.display = input.length > 0 && found ? "block" : "none";
    }
</script>

<script>
    function filterHospitals() {
      var input = document.getElementById("hospitalSearch").value.toLowerCase();
      var select = document.getElementById("hospitalSelect");
      var options = select.options;
      var found = false;
    
      for (var i = 0; i < options.length; i++) {
        var txt = options[i].text.toLowerCase();
        if (txt.includes(input)) {
          options[i].style.display = "";
          found = true;
        } else {
          options[i].style.display = "none";
        }
      }
    
      // Show dropdown only if search text is not empty and a match is found
      select.style.display = input.length > 0 && found ? "block" : "none";
    }
</script>

<!-- Toastr CSS -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
<!-- Toastr JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>


<script>
// Show toast using jQuery
function showToast(title, message, type) {
    toastr.options = {
        closeButton: true,
        progressBar: true,
        positionClass: "toast-top-right",
        timeOut: "3000",
    };

    if (type === 'success') {
        toastr.success(message, title);
    } else if (type === 'error') {
        toastr.error(message, title);
    } else if (type === 'info') {
        toastr.info(message, title);
    } else if (type === 'warning') {
        toastr.warning(message, title);
    }
}


</script>
            