<div class="container-xxl flex-grow-1 container-p-y">
              <h4 class="py-3 mb-4"><span class="text-muted fw-light">User App Ios Version</h4>
              
  <div class="row"><div class="col-md-6">
      <div class="card mb-4">
          <form method="post" action="#" id="inputform" enctype="multipart/form-data">
        <div class="card-body">
            
            
            <div class="mb-3">
              <label for="versionInput" class="form-label">User App iOS Version *</label>
              <input
                type="text"
                class="form-control"
                id="versionInput"
                name="version"
                placeholder="User App iOS Version"
                required
                maxlength="20"
                value="<?= htmlspecialchars($user_app_ios_version[0]['version'] ?? '') ?>"
                pattern="^\d+(\.\d+)*$"
              />
              <div class="invalid-feedback">Enter version like 1, 1.0, or 1.2.3</div>
            </div>
            
            <script>
            document.addEventListener('DOMContentLoaded', function () {
              const input = document.getElementById('versionInput');
            
              // Allow typing but remove non-digit/non-dot and collapse multiple dots to single,
              // keep a trailing dot while typing (so user can type "1." then "1.2").
              input.addEventListener('input', function () {
                const old = this.value;
                // remove any non digit or dot
                let v = old.replace(/[^0-9.]/g, '');
                // collapse consecutive dots into one
                v = v.replace(/\.{2,}/g, '.');
                // prevent a leading dot while typing
                if (v.startsWith('.')) v = v.slice(1);
            
                // try to preserve caret position
                try {
                  const oldPos = this.selectionStart;
                  const diff = old.length - v.length;
                  let newPos = Math.max(0, oldPos - diff);
                  this.value = v;
                  this.setSelectionRange(newPos, newPos);
                } catch (e) {
                  // fallback if selectionStart not supported
                  this.value = v;
                }
              });
            
              // On blur: clean up trailing/leading dots and empty segments, then validate.
              input.addEventListener('blur', function () {
                let v = this.value;
                // remove leading/trailing dots
                v = v.replace(/^\.+|\.+$/g, '');
                // remove any empty segments produced by stray dots
                v = v.split('.').filter(Boolean).join('.');
                this.value = v;
            
                // set custom validity for better message
                const ok = /^\d+(\.\d+)*$/.test(v) || v === '';
                this.setCustomValidity(ok ? '' : 'Version must be numbers separated by dots (e.g. 1, 1.0, 1.2.3).');
              });
            
              // Optional: prevent form submit if invalid and show message
              const form = input.closest('form');
              if (form) {
                form.addEventListener('submit', function (ev) {
                  const v = input.value.trim();
                  if (!/^\d+(\.\d+)*$/.test(v)) {
                    input.reportValidity();
                    ev.preventDefault();
                  }
                });
              }
            });
            </script>




          
        </div>
      </div>
       <button type="button" name="sub" value="sub" class="btn btn-success" id="saveBtn">Submit</button>
      </form>
      <!--<a href="<?=base_url('admin/register/coverage_categories')?>"><button type="button" class="btn btn-danger">Cancel</button></a>-->
    </div></div>
</div>



<script>
$(document).ready(function () {
    $('#saveBtn').on('click', function () {
        let isValid = true;

        // Validate required fields
        $('#inputform [required]').each(function () {
            let value = $(this).val();
            if (Array.isArray(value)) {
                value = value.join('');
            }
            value = value ? value.toString().trim() : '';
            const fieldName = $(this).attr('name');

            if (value === '') {
                isValid = false;
                $(this).addClass('is-invalid');
                showToast('Error', `${$(this).attr('placeholder')} is required`, 'error');
                return;
            }

            $(this).removeClass('is-invalid').addClass('is-valid');
        });

        if (isValid) {
            const form = $('#inputform')[0];
            const formData = new FormData(form);

            $.ajax({
                url: '<?= base_url("admin/register/edit_user_app_ios_version_data"); ?>',
                type: 'POST',
                data: formData,
                contentType: false,
                processData: false,
                success: function (response) {
                    const res = JSON.parse(response);
                    if (res.success) {
                        showToast('Success', res.message, 'success');
                        //$('#inputform')[0].reset();
                        $('.form-control').removeClass('is-valid');
                        //window.location.href = '<?= base_url("admin/register/coverage_categories") ?>';
                    } else {
                        showToast('Error', res.message, 'error');
                    }
                },
                error: function () {
                    showToast('Error', 'An unexpected error occurred.', 'error');
                },
            });
        } else {
            $('html, body').animate({
                scrollTop: $('.is-invalid:first').offset().top - 100,
            }, 500);
        }
    });

    // Real-time validation feedback
    $('#inputform .form-control').on('input change', function () {
        const value = $(this).val().trim();
        const fieldName = $(this).attr('name');
        let isFieldValid = true;

        if (value === '') {
            isFieldValid = false;
        } else {

        }

        if (isFieldValid) {
            $(this).removeClass('is-invalid').addClass('is-valid');
        } else {
            $(this).removeClass('is-valid').addClass('is-invalid');
        }
    });
});
</script>

<!-- Toastr CSS -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
<!-- Toastr JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>


<script>
// Show toast using jQuery
function showToast(title, message, type) {
    toastr.options = {
        closeButton: true,
        progressBar: true,
        positionClass: "toast-top-right",
        timeOut: "3000",
    };

    if (type === 'success') {
        toastr.success(message, title);
    } else if (type === 'error') {
        toastr.error(message, title);
    } else if (type === 'info') {
        toastr.info(message, title);
    } else if (type === 'warning') {
        toastr.warning(message, title);
    }
}


</script>
            