    <div class="container-xxl flex-grow-1 container-p-y">
              <h4 class="py-3 mb-4"><span class="text-muted fw-light">Pharmacy Statistics</h4>
              
    <div class="row">
      <div class="col-md-12">
      <div class="card mb-4">
          
        <div class="card-body">
            
            <div class="mb-3">
              <label class="form-label">Year *</label>
              <select class="form-select" id="yearSelect" required>
                <option value="">Select Year</option>
              </select>
            </div>
            
            <script>
              const currentYear = new Date().getFullYear();
              for (let year = currentYear; year >= currentYear - 9; year--) {
                $('#yearSelect').append(`<option value="${year}">${year}</option>`);
              }
              
              $('#yearSelect').on('change', function () {
                  const year = $(this).val();
                  if (year) {

                    fetchPharmacyprescriptionData(year).then(data => {
                      console.log("Pharmacy Prescription Chart Data:", data); // ✅ Add this
                      renderPharmacyprescriptionChart(data);
                    });
                    
                  }
                });


            </script>


          
        </div>
      </div>
       
       <div class="col-md-12 col-12 mt-4 mb-4 ">
        <div class="row">
        
            <!--pharmacy prescription booking-->
                <div class="col-lg-12 mb-4">
                        <div class="card">
                          <div class="card-header d-flex align-items-center justify-content-between">
                            <h5 class="card-title mb-0">Pharmacy Prescription Bookings</h5>
                          </div>
                          <div class="card-body">
                            <div id="pharmacyprescriptionChart"></div>
                          </div>
                        </div>
                      </div>
                    
                <script>
                
                const months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
                                      'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
                                      
                      let pharmacyprescriptionChart;
                    
                      function renderPharmacyprescriptionChart(data) {
                        const options = {
                          series: [
                            { name: 'Booked', data: data.booked },
                            { name: 'Completed', data: data.completed },
                            { name: 'Cancelled', data: data.cancelled }
                          ],
                          chart: { type: 'bar', height: 350 },
                          plotOptions: {
                            bar: { horizontal: false, columnWidth: '100%', borderRadius: 5, borderRadiusApplication: 'end' }
                          },
                          dataLabels: { enabled: false },
                          stroke: { show: true, width: 2, colors: ['transparent'] },
                          xaxis: { categories: months },
                          yaxis: { title: { text: 'Number of Bookings' } },
                          fill: { opacity: 1 },
                          tooltip: {
                            y: { formatter: val => val + " bookings" }
                          }
                        };
                    
                        if (pharmacyprescriptionChart) {
                          pharmacyprescriptionChart.updateOptions(options);
                        } else {
                          pharmacyprescriptionChart = new ApexCharts(document.querySelector("#pharmacyprescriptionChart"), options);
                          pharmacyprescriptionChart.render();
                        }
                      }
                    
                      function fetchPharmacyprescriptionData(year) {
                        return $.ajax({
                          url: '<?= base_url('admin/register/get_main_pharmacy_prescription_booking_stats_by_year') ?>',
                          method: 'POST',
                          data: { year: year },
                          dataType: 'json'
                        });
                      }
                    </script>
            <!--pharmacy prescription booking-->
            
            
        </div>
    
    </div>
    </div>
      
    </div>
    </div>
