<?php 
$districts = $this->registermodel->common_fetch_asc('districts',['state_id' => $village[0]['state_id'],'status' => 1,'delete_status' => 1]);
$mandals = $this->registermodel->common_fetch_asc('mandals',['state_id' => $village[0]['state_id'],'status' => 1,'delete_status' => 1]);
//print_r($districts);exit;
?>

<div class="container-xxl flex-grow-1 container-p-y">
              <h4 class="py-3 mb-4"><span class="text-muted fw-light">Edit Village</h4>
              
  <div class="row"><div class="col-md-6">
      <div class="card mb-4">
          <form method="post" action="#" id="inputform" enctype="multipart/form-data">
        <div class="card-body">
            
          <div class="mb-3">
            <label for="exampleFormControlInput1" class="form-label">State *</label>
            <select class="form-select" id="state_id" name="state_id" placeholder="State" required>
                <option value="">Select State</option>
                <?php foreach($states as $row){?>
                <option value="<?=$row['id']?>" <?php if($row['id']==$village[0]['state_id']){echo 'selected="selected"';}?>><?=$row['name']?></option>
                <?php } ?>
            </select>
          </div>
          
        
            <div class="mb-3">
              <label class="form-label">District *</label>
              <select class="form-select" name="district_id" id="district_id" required placeholder="District">
                <option value="">Select District</option>
                <?php foreach($districts as $di_row){?>
                <option value="<?=$di_row['id']?>" <?php if($di_row['id']==$village[0]['district_id']){echo 'selected="selected"';}?>><?=$di_row['name']?></option>
                <?php } ?>
              </select>
            </div>
            
            <div class="mb-3">
              <label class="form-label">Mandal *</label>
              <select class="form-select" name="mandal_id" id="mandal_id" required placeholder="Mandal">
                <option value="">Select Mandal</option>
                <?php foreach($mandals as $ma_row){?>
                <option value="<?=$ma_row['id']?>" <?php if($ma_row['id']==$village[0]['mandal_id']){echo 'selected="selected"';}?>><?=$ma_row['name']?></option>
                <?php } ?>
              </select>
            </div>

          
          <div class="mb-3">
            <label for="exampleFormControlInput1" class="form-label">Name *</label>
            <input
              type="text"
              class="form-control"
              id="exampleFormControlInput1"
              placeholder="Name" name="name" required value="<?=$village[0]['name']?>"/>
          </div>
          
        </div>
      </div>
       <button type="button" name="sub" value="sub" class="btn btn-success" id="saveBtn">Submit</button>
      </form>
      <a href="<?=base_url('admin/register/villages')?>"><button type="button" class="btn btn-danger">Cancel</button></a>
    </div></div>
</div>



<script>
$(document).ready(function () {
    $('#saveBtn').on('click', function () {
        let isValid = true;

        // Validate required fields
        $('#inputform [required]').each(function () {
            let value = $(this).val();
            if (Array.isArray(value)) {
                value = value.join('');
            }
            value = value ? value.toString().trim() : '';
            const fieldName = $(this).attr('name');

            if (value === '') {
                isValid = false;
                $(this).addClass('is-invalid');
                showToast('Error', `${$(this).attr('placeholder')} is required`, 'error');
                return;
            }

            // Name validation
            if (fieldName === 'name') {
                const namePattern = /^[A-Za-z][^0-9]{2,}$/;
                if (!namePattern.test(value)) {
                    isValid = false;
                    $(this).addClass('is-invalid');
                    showToast('Error', 'Name must not start with a special character and must be at least 3 characters and numbers are not allowed', 'error');
                    return;
                }
            }

            $(this).removeClass('is-invalid').addClass('is-valid');
        });

        if (isValid) {
            const form = $('#inputform')[0];
            const formData = new FormData(form);

            $.ajax({
                url: '<?= base_url("admin/register/edit_village_data/".$village[0]['id']); ?>',
                type: 'POST',
                data: formData,
                contentType: false,
                processData: false,
                success: function (response) {
                    const res = JSON.parse(response);
                    if (res.success) {
                        showToast('Success', res.message, 'success');
                        //$('#inputform')[0].reset();
                        $('.form-control').removeClass('is-valid');
                        window.location.href = '<?= base_url("admin/register/villages") ?>';
                    } else {
                        showToast('Error', res.message, 'error');
                    }
                },
                error: function () {
                    showToast('Error', 'An unexpected error occurred.', 'error');
                },
            });
        } else {
            $('html, body').animate({
                scrollTop: $('.is-invalid:first').offset().top - 100,
            }, 500);
        }
    });

    // Real-time validation feedback
    $('#inputform .form-control').on('input change', function () {
        const value = $(this).val().trim();
        const fieldName = $(this).attr('name');
        let isFieldValid = true;

        if (value === '') {
            isFieldValid = false;
        } else {
            switch (fieldName) {
                case 'name':
                    isFieldValid = /^[A-Za-z][^0-9]{2,}$/.test(value);
                    break;
            }

        }

        if (isFieldValid) {
            $(this).removeClass('is-invalid').addClass('is-valid');
        } else {
            $(this).removeClass('is-valid').addClass('is-invalid');
        }
    });
});
</script>

<script>
  $('#state_id').on('change', function () {
    var state_id = $(this).val();
    $('#district_id').html('<option value="">Select District</option>');
    $('#city_id').html('<option value="">Select City</option>');

    if (state_id !== '') {
      $.ajax({
        url: '<?= base_url('admin/register/get_districts_by_state') ?>',
        type: 'POST',
        data: { state_id: state_id },
        success: function (data) {
          var districts = JSON.parse(data);
          $.each(districts, function (index, district) {
            $('#district_id').append('<option value="' + district.id + '">' + district.name + '</option>');
          });
        }
      });
    }
  });

  $('#district_id').on('change', function () {
    var district_id = $(this).val();
    var state_id = $('#state_id').val();
    $('#mandal_id').html('<option value="">Select Mandal</option>');

    if (state_id !== '' && district_id !== '') {
      $.ajax({
        url: '<?= base_url('admin/register/get_mandals_by_state_district') ?>',
        type: 'POST',
        data: { state_id: state_id, district_id: district_id },
        success: function (data) {
          var cities = JSON.parse(data);
          $.each(cities, function (index, city) {
            $('#mandal_id').append('<option value="' + city.id + '">' + city.name + '</option>');
          });
        }
      });
    }
  });
</script>
<!-- Toastr CSS -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
<!-- Toastr JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>


<script>
// Show toast using jQuery
function showToast(title, message, type) {
    toastr.options = {
        closeButton: true,
        progressBar: true,
        positionClass: "toast-top-right",
        timeOut: "3000",
    };

    if (type === 'success') {
        toastr.success(message, title);
    } else if (type === 'error') {
        toastr.error(message, title);
    } else if (type === 'info') {
        toastr.info(message, title);
    } else if (type === 'warning') {
        toastr.warning(message, title);
    }
}


</script>
            