    <div class="container-xxl flex-grow-1 container-p-y">
              <h4 class="py-3 mb-4"><span class="text-muted fw-light">Statistics</h4>
              
    <div class="row">
      <div class="col-md-12">
      <div class="card mb-4">
          
        <div class="card-body">
            
            <div class="mb-3">
              <label class="form-label">Year *</label>
              <select class="form-select" id="yearSelect" required>
                <option value="">Select Year</option>
              </select>
            </div>
            
            <script>
              const currentYear = new Date().getFullYear();
              for (let year = currentYear; year >= currentYear - 9; year--) {
                $('#yearSelect').append(`<option value="${year}">${year}</option>`);
              }
              
              $('#yearSelect').on('change', function () {
                  const year = $(this).val();
                  if (year) {
                    fetchAmbulanceData(year).then(data => {
                      console.log("Ambulance Chart Data:", data); // ✅ Add this
                      renderAmbulanceChart(data);
                    });
                
                    fetchAdmitData(year).then(data => {
                      console.log("Admit Chart Data:", data); // ✅ Add this
                      renderAdmitChart(data);
                    });
                    
                    fetchDoctorData(year).then(data => {
                      console.log("Doctor Chart Data:", data); // ✅ Add this
                      renderDoctorChart(data);
                    });
                    
                    fetchWellnessproductsData(year).then(data => {
                      console.log("Wellness Products Chart Data:", data); // ✅ Add this
                      renderWellnessproductsChart(data);
                    });
                    
                    fetchPharmacyprescriptionData(year).then(data => {
                      console.log("Pharmacy Prescription Chart Data:", data); // ✅ Add this
                      renderPharmacyprescriptionChart(data);
                    });
                    
                    fetchDiagnosticData(year).then(data => {
                      console.log("Diagnostic Chart Data:", data); // ✅ Add this
                      renderDiagnosticChart(data);
                    });
                    
                    fetchDiagnosticprescriptionData(year).then(data => {
                      console.log("Diagnostic Prescription Chart Data:", data); // ✅ Add this
                      renderDiagnosticprescriptionChart(data);
                    });
                  }
                });


            </script>


          
        </div>
      </div>
       
       <div class="col-md-12 col-12 mt-4 mb-4 ">
        <div class="row">
            
            <!--ambulance booking-->
                <div class="col-lg-12 mb-4">
                    <div class="card">
                      <div class="card-header d-flex align-items-center justify-content-between">
                        <h5 class="card-title mb-0">Ambulance Bookings</h5>
                      </div>
                      <div class="card-body">
                        <div id="ambulanceChart"></div>
                      </div>
                    </div>
                  </div>
                    
                <script>
                      const months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
                                      'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
                      let ambulanceChart;
                    
                      function renderAmbulanceChart(data) {
                        const options = {
                          series: [
                            { name: 'Booked', data: data.booked },
                            { name: 'Completed', data: data.completed },
                            { name: 'Cancelled', data: data.cancelled } // renamed to match backend key
                          ],
                          chart: { type: 'bar', height: 350 },
                          plotOptions: {
                            bar: { horizontal: false, columnWidth: '100%', borderRadius: 5, borderRadiusApplication: 'end' }
                          },
                          dataLabels: { enabled: false },
                          stroke: { show: true, width: 2, colors: ['transparent'] },
                          xaxis: { categories: months },
                          yaxis: { title: { text: 'Number of Bookings' } },
                          fill: { opacity: 1 },
                          tooltip: {
                            y: { formatter: val => val + " bookings" }
                          }
                        };
                    
                        if (ambulanceChart) {
                          ambulanceChart.updateOptions(options);
                        } else {
                          ambulanceChart = new ApexCharts(document.querySelector("#ambulanceChart"), options);
                          ambulanceChart.render();
                        }
                      }
                    
                      function fetchAmbulanceData(year) {
                        return $.ajax({
                          url: '<?= base_url('admin/register/get_ambulance_booking_stats_by_year') ?>',
                          method: 'POST',
                          data: { year: year },
                          dataType: 'json'
                        });
                      }
                    </script>
            <!--ambulance booking-->
            
            <!--admit booking-->
                <div class="col-lg-12 mb-4">
                        <div class="card">
                          <div class="card-header d-flex align-items-center justify-content-between">
                            <h5 class="card-title mb-0">Admit Bookings</h5>
                          </div>
                          <div class="card-body">
                            <div id="admitChart"></div>
                          </div>
                        </div>
                      </div>
                    
                <script>
                      let admitChart;
                    
                      function renderAdmitChart(data) {
                        const options = {
                          series: [
                            { name: 'Booked', data: data.booked },
                            { name: 'Completed', data: data.completed },
                            { name: 'Cancelled', data: data.cancelled }
                          ],
                          chart: { type: 'bar', height: 350 },
                          plotOptions: {
                            bar: { horizontal: false, columnWidth: '100%', borderRadius: 5, borderRadiusApplication: 'end' }
                          },
                          dataLabels: { enabled: false },
                          stroke: { show: true, width: 2, colors: ['transparent'] },
                          xaxis: { categories: months },
                          yaxis: { title: { text: 'Number of Bookings' } },
                          fill: { opacity: 1 },
                          tooltip: {
                            y: { formatter: val => val + " bookings" }
                          }
                        };
                    
                        if (admitChart) {
                          admitChart.updateOptions(options);
                        } else {
                          admitChart = new ApexCharts(document.querySelector("#admitChart"), options);
                          admitChart.render();
                        }
                      }
                    
                      function fetchAdmitData(year) {
                        return $.ajax({
                          url: '<?= base_url('admin/register/get_admit_booking_stats_by_year') ?>',
                          method: 'POST',
                          data: { year: year },
                          dataType: 'json'
                        });
                      }
                    </script>
            <!--admit booking-->
            
            <!--doctor booking-->
                <div class="col-lg-12 mb-4">
                        <div class="card">
                          <div class="card-header d-flex align-items-center justify-content-between">
                            <h5 class="card-title mb-0">Doctor Bookings</h5>
                          </div>
                          <div class="card-body">
                            <div id="doctorChart"></div>
                          </div>
                        </div>
                      </div>
                    
                <script>
                      let doctorChart;
                    
                      function renderDoctorChart(data) {
                        const options = {
                          series: [
                            { name: 'Booked', data: data.booked },
                            { name: 'Completed', data: data.completed },
                            { name: 'Cancelled', data: data.cancelled }
                          ],
                          chart: { type: 'bar', height: 350 },
                          plotOptions: {
                            bar: { horizontal: false, columnWidth: '100%', borderRadius: 5, borderRadiusApplication: 'end' }
                          },
                          dataLabels: { enabled: false },
                          stroke: { show: true, width: 2, colors: ['transparent'] },
                          xaxis: { categories: months },
                          yaxis: { title: { text: 'Number of Bookings' } },
                          fill: { opacity: 1 },
                          tooltip: {
                            y: { formatter: val => val + " bookings" }
                          }
                        };
                    
                        if (doctorChart) {
                          doctorChart.updateOptions(options);
                        } else {
                          doctorChart = new ApexCharts(document.querySelector("#doctorChart"), options);
                          doctorChart.render();
                        }
                      }
                    
                      function fetchDoctorData(year) {
                        return $.ajax({
                          url: '<?= base_url('admin/register/get_doctor_booking_stats_by_year') ?>',
                          method: 'POST',
                          data: { year: year },
                          dataType: 'json'
                        });
                      }
                    </script>
            <!--doctor booking-->
            
            <!--wellness product booking-->
                <div class="col-lg-12 mb-4">
                        <div class="card">
                          <div class="card-header d-flex align-items-center justify-content-between">
                            <h5 class="card-title mb-0">Wellness Product Bookings</h5>
                          </div>
                          <div class="card-body">
                            <div id="wellnessproductsChart"></div>
                          </div>
                        </div>
                      </div>
                    
                <script>
                      let wellnessproductsChart;
                    
                      function renderWellnessproductsChart(data) {
                        const options = {
                          series: [
                            { name: 'Booked', data: data.booked },
                            { name: 'Completed', data: data.completed },
                            { name: 'Cancelled', data: data.cancelled }
                          ],
                          chart: { type: 'bar', height: 350 },
                          plotOptions: {
                            bar: { horizontal: false, columnWidth: '100%', borderRadius: 5, borderRadiusApplication: 'end' }
                          },
                          dataLabels: { enabled: false },
                          stroke: { show: true, width: 2, colors: ['transparent'] },
                          xaxis: { categories: months },
                          yaxis: { title: { text: 'Number of Bookings' } },
                          fill: { opacity: 1 },
                          tooltip: {
                            y: { formatter: val => val + " bookings" }
                          }
                        };
                    
                        if (wellnessproductsChart) {
                          wellnessproductsChart.updateOptions(options);
                        } else {
                          wellnessproductsChart = new ApexCharts(document.querySelector("#wellnessproductsChart"), options);
                          wellnessproductsChart.render();
                        }
                      }
                    
                      function fetchWellnessproductsData(year) {
                        return $.ajax({
                          url: '<?= base_url('admin/register/get_wellness_product_booking_stats_by_year') ?>',
                          method: 'POST',
                          data: { year: year },
                          dataType: 'json'
                        });
                      }
                    </script>
            <!--wellness product booking-->
            
            <!--pharmacy prescription booking-->
                <div class="col-lg-12 mb-4">
                        <div class="card">
                          <div class="card-header d-flex align-items-center justify-content-between">
                            <h5 class="card-title mb-0">Pharmacy Prescription Bookings</h5>
                          </div>
                          <div class="card-body">
                            <div id="pharmacyprescriptionChart"></div>
                          </div>
                        </div>
                      </div>
                    
                <script>
                      let pharmacyprescriptionChart;
                    
                      function renderPharmacyprescriptionChart(data) {
                        const options = {
                          series: [
                            { name: 'Booked', data: data.booked },
                            { name: 'Completed', data: data.completed },
                            { name: 'Cancelled', data: data.cancelled }
                          ],
                          chart: { type: 'bar', height: 350 },
                          plotOptions: {
                            bar: { horizontal: false, columnWidth: '100%', borderRadius: 5, borderRadiusApplication: 'end' }
                          },
                          dataLabels: { enabled: false },
                          stroke: { show: true, width: 2, colors: ['transparent'] },
                          xaxis: { categories: months },
                          yaxis: { title: { text: 'Number of Bookings' } },
                          fill: { opacity: 1 },
                          tooltip: {
                            y: { formatter: val => val + " bookings" }
                          }
                        };
                    
                        if (pharmacyprescriptionChart) {
                          pharmacyprescriptionChart.updateOptions(options);
                        } else {
                          pharmacyprescriptionChart = new ApexCharts(document.querySelector("#pharmacyprescriptionChart"), options);
                          pharmacyprescriptionChart.render();
                        }
                      }
                    
                      function fetchPharmacyprescriptionData(year) {
                        return $.ajax({
                          url: '<?= base_url('admin/register/get_pharmacy_prescription_booking_stats_by_year') ?>',
                          method: 'POST',
                          data: { year: year },
                          dataType: 'json'
                        });
                      }
                    </script>
            <!--pharmacy prescription booking-->
            
            <!--diagnostic booking-->
                <div class="col-lg-12 mb-4">
                        <div class="card">
                          <div class="card-header d-flex align-items-center justify-content-between">
                            <h5 class="card-title mb-0">Diagnostic Bookings</h5>
                          </div>
                          <div class="card-body">
                            <div id="diagnosticChart"></div>
                          </div>
                        </div>
                      </div>
                    
                <script>
                      let diagnosticChart;
                    
                      function renderDiagnosticChart(data) {
                        const options = {
                          series: [
                            { name: 'Booked', data: data.booked },
                            { name: 'Completed', data: data.completed },
                            { name: 'Cancelled', data: data.cancelled }
                          ],
                          chart: { type: 'bar', height: 350 },
                          plotOptions: {
                            bar: { horizontal: false, columnWidth: '100%', borderRadius: 5, borderRadiusApplication: 'end' }
                          },
                          dataLabels: { enabled: false },
                          stroke: { show: true, width: 2, colors: ['transparent'] },
                          xaxis: { categories: months },
                          yaxis: { title: { text: 'Number of Bookings' } },
                          fill: { opacity: 1 },
                          tooltip: {
                            y: { formatter: val => val + " bookings" }
                          }
                        };
                    
                        if (diagnosticChart) {
                          diagnosticChart.updateOptions(options);
                        } else {
                          diagnosticChart = new ApexCharts(document.querySelector("#diagnosticChart"), options);
                          diagnosticChart.render();
                        }
                      }
                    
                      function fetchDiagnosticData(year) {
                        return $.ajax({
                          url: '<?= base_url('admin/register/get_diagnostic_booking_stats_by_year') ?>',
                          method: 'POST',
                          data: { year: year },
                          dataType: 'json'
                        });
                      }
                    </script>
            <!--diagnostic booking-->
            
            <!--diagnostic prescription booking-->
                <div class="col-lg-12 mb-4">
                        <div class="card">
                          <div class="card-header d-flex align-items-center justify-content-between">
                            <h5 class="card-title mb-0">Diagnostic Prescription Bookings</h5>
                          </div>
                          <div class="card-body">
                            <div id="diagnosticprescriptionChart"></div>
                          </div>
                        </div>
                      </div>
                    
                <script>
                      let diagnosticprescriptionChart;
                    
                      function renderDiagnosticprescriptionChart(data) {
                        const options = {
                          series: [
                            { name: 'Booked', data: data.booked },
                            { name: 'Completed', data: data.completed },
                            { name: 'Cancelled', data: data.cancelled }
                          ],
                          chart: { type: 'bar', height: 350 },
                          plotOptions: {
                            bar: { horizontal: false, columnWidth: '100%', borderRadius: 5, borderRadiusApplication: 'end' }
                          },
                          dataLabels: { enabled: false },
                          stroke: { show: true, width: 2, colors: ['transparent'] },
                          xaxis: { categories: months },
                          yaxis: { title: { text: 'Number of Bookings' } },
                          fill: { opacity: 1 },
                          tooltip: {
                            y: { formatter: val => val + " bookings" }
                          }
                        };
                    
                        if (diagnosticprescriptionChart) {
                          diagnosticprescriptionChart.updateOptions(options);
                        } else {
                          diagnosticprescriptionChart = new ApexCharts(document.querySelector("#diagnosticprescriptionChart"), options);
                          diagnosticprescriptionChart.render();
                        }
                      }
                    
                      function fetchDiagnosticprescriptionData(year) {
                        return $.ajax({
                          url: '<?= base_url('admin/register/get_diagnostic_prescription_booking_stats_by_year') ?>',
                          method: 'POST',
                          data: { year: year },
                          dataType: 'json'
                        });
                      }
                    </script>
            <!--diagnostic booking-->
            
        </div>
    
    </div>
    </div>
      
    </div>
    </div>
