<!DOCTYPE html>

<html
  lang="en"
  class="light-style layout-wide customizer-hide"
  dir="ltr"
  data-theme="theme-default"
  data-assets-path="<?php  echo base_url();?>assets/admin/main/"
  data-template="vertical-menu-template">
  <head>
    <meta charset="utf-8" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>Dashboard</title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php  echo base_url();?>assets/admin/admin_logo.png" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&ampdisplay=swap"
      rel="stylesheet" />

    <!-- Icons -->
    <link rel="stylesheet" href="<?php  echo base_url();?>assets/admin/main/vendor/fonts/fontawesome.css" />
    <link rel="stylesheet" href="<?php  echo base_url();?>assets/admin/main/vendor/fonts/tabler-icons.css" />
    <link rel="stylesheet" href="<?php  echo base_url();?>assets/admin/main/vendor/fonts/flag-icons.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="<?php  echo base_url();?>assets/admin/main/vendor/css/rtl/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="<?php  echo base_url();?>assets/admin/main/vendor/css/rtl/theme-default.css" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="<?php  echo base_url();?>assets/admin/main/css/demo.css" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="<?php  echo base_url();?>assets/admin/main/vendor/libs/node-waves/node-waves.css" />
    <link rel="stylesheet" href="<?php  echo base_url();?>assets/admin/main/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="<?php  echo base_url();?>assets/admin/main/vendor/libs/typeahead-js/typeahead.css" />
    <!-- Vendor -->
    <link rel="stylesheet" href="<?php  echo base_url();?>assets/admin/main/vendor/libs/@form-validation/umd/styles/index.min.css" />

    <!-- Page CSS -->
    <!-- Page -->
    <link rel="stylesheet" href="<?php  echo base_url();?>assets/admin/main/vendor/css/pages/page-auth.css" />

    <!-- Helpers -->
    <script src="<?php  echo base_url();?>assets/admin/main/vendor/js/helpers.js"></script>
    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Template customizer: To hide customizer set displayCustomizer value false in config.js.  -->
    <script src="<?php  echo base_url();?>assets/admin/main/vendor/js/template-customizer.js"></script>
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="<?php  echo base_url();?>assets/admin/main/js/config.js"></script>
  </head>

  <body>
    <!-- Content -->

    <div class="" style='background:url("https://odigossoft.com/hospitals/assets/admin/dots-img.webp"); background-size:cover; background-repeat:no-repeat'>
      <div class="authentication-inner  row">
       

        <!-- Login -->
        <div class=" col-lg-12 align-items-center p-sm-5 ">
       <div class='container'>
              <div class=" glass-card ">
            <!-- Logo -->
           
            <!-- /Logo -->
            <h3 class="mb-1">Welcome to Admin!</h3>
            <p class="mb-4">Please sign-up to your account and start the adventure</p>

            <form action="#" class="form-content" id="inputform" enctype="multipart/form-data">
                
            <div class='row'>
                <div class='col-lg-4'>
                <div class="mb-3">
                <label for="name" class="form-label "> Name</label>
                <input
                  type="text"
                  class="form-control"
                  id="name"
                  name="name"
                  placeholder="Name" required/>
              </div>
                </div>
                <div class='col-lg-4'>
                     <div class="mb-3">
                <label for="mobile" class="form-label"> Mobile</label>
                <input
                  type="tel"
                  class="form-control"
                  id="mobile"
                  name="mobile"
                  required autofocus  maxlength="10" pattern="[0-9]{10}" required placeholder="Mobile" oninput="this.value = this.value.replace(/[^0-9]/g, '')" />
              </div>
                </div>
                <div class='col-lg-4'>
                <div class="mb-3">
                <label for="email" class="form-label"> Email</label>
                <input
                  type="email"
                  class="form-control"
                  id="email"
                  name="email"
                  placeholder="Email" required/>
              </div>
                    
                </div>
                
                <div class='col-lg-4'>
                       <div class="mb-3">
                <label for="logo" class="form-label"> Logo</label>
                <input
                  type="file"
                  class="form-control"
                  id="logo"
                  name="logo"
                  placeholder="Logo"/>
              </div>
              <p style="color:red">please upload only jpg,jpeg or png files</p>
                </div>
                <div class='col-lg-4'>
                      <div class="mb-3">
                <label for="cat_id" class="form-label"> Categories</label>
                <select class="form-select" id="cat_id" name="cat_id" placeholder="Category" required onchange="get_specialities(this.value)">
                    <option value="">Select Category</option>
                    <?php if(!empty($categories)){ 
                        foreach($categories as $row){ ?>
                        <option value="<?=$row['id']?>"><?=$row['name']?></option>
                    <?php } } ?>
                </select>
             </div>
                </div>
                 <div class='col-lg-4'>
                      <div class="mb-3">
                <label for="speciality_id" class="form-label"> Specialities</label>
                <select class="form-select" id="speciality_id" name="speciality_id" placeholder="Speciality" required multiple>
                </select>
              </div> 
              <small class="form-text text-muted">Hold down <strong>Ctrl</strong> (or <strong>Cmd</strong> on Mac) to select multiple options.</small>
                 </div> 
                 
                  <div class='col-lg-4'>
                      <div class="mb-3">
                <label for="pharmacy" class="form-label"> Pharmacy</label>
                <select class="form-select" id="pharmacy" name="pharmacy" placeholder="Pharmacy" required>
                    <option value="">Select Status</option>
                    <option value="yes">Yes</option>
                    <option value="no">No</option>
                </select>
            </div> 
                  </div> 
                  <div class='col-lg-4'>
                         <div class="mb-3">
                <label for="diagnostic" class="form-label"> Diagnostic</label>
                <select class="form-select" id="diagnostic" name="diagnostic" placeholder="Diagnostic" required>
                    <option value="">Select Status</option>
                    <option value="yes">Yes</option>
                    <option value="no">No</option>
                </select>
            </div>
                  </div>
                  <div class='col-lg-4'>
                       <div class="mb-3">
                <label for="home_delivery" class="form-label"> Home Delivery</label>
                <select class="form-select" id="home_delivery" name="home_delivery" placeholder="Home Delivery" required>
                    <option value="">Select Status</option>
                    <option value="yes">Yes</option>
                    <option value="no">No</option>
                </select>
            </div>
                  </div>
                
                    <div class='col-lg-4'>
                        <div class="mb-3">
                        <label for="location" class="form-label"> Location</label>
                        <textarea class="form-control" id="location" name="location" placeholder="Location" rows='1'  required></textarea>
                    </div>
                 </div>
                  <div class='col-lg-4'>
                      <div class="mb-3">
                        <label for="latitude" class="form-label"> Latitude</label>
                        <input
                          type="text"
                          class="form-control"
                          id="latitude"
                          name="lat"
                          placeholder="Latitude"
                          required
                          pattern="^-?\d+\.\d+$"
                          title="Enter a valid latitude (positive or negative decimal)"/>


                      </div>
                  </div>
                   <div class='col-lg-4'>
                       <div class="mb-3">
                        <label for="longitude" class="form-label"> Longitude</label>
                        <input
                          type="text"
                          class="form-control"
                          id="longitude"
                          name="lon"
                          placeholder="Longitude"
                          required
                          pattern="^-?\d+\.\d+$"
                          title="Enter a valid longitude (positive or negative decimal)"/>


                      </div> 
                   </div>
                   
                    <div class='col-lg-4'>
                       <div class="mb-3">
                            <label for="description" class="form-label"> Description</label>
                            <textarea class="form-control" id="description" name="description" placeholder="Description" rows="1" cols="10" required></textarea>
                        </div>  
                    </div>
                    
                     <div class='col-lg-4'>
                            <div class="mb-3">
              <label for="open_time" class="form-label">Open Time</label>
              <select class="form-control" id="open_time" name="open_time" placeholder="Open time" required>
                <!-- Options will be populated by JS -->
              </select>
                </div>
                     </div>
                    <div class='col-lg-4'>
                        <div class="mb-3">
                          <label for="close_time" class="form-label">Close Time</label>
                          <select class="form-control" id="close_time" name="close_time" placeholder="Close time" required>
                            <!-- Options will be populated by JS -->
                          </select>
                        </div>  
                    </div>
                
                <div class='mb-3'>
                  <button type="button" class="btn btn-primary " id="saveBtn" > Sign up</button>
                </div>
                
                
            </div>
              
             
            </form>
            <p>Already have an account ? <a href="<?=base_url('admin/login')?>">Login</a></p>
          </div>
       </div>
        </div>
        <!-- /Login -->
      </div>
    </div>
    
    <style>
        body{
            overflow-x:hidden;
        }
         
        .glass-card {
            
     padding: 3rem 2rem;
      background: rgba(255, 255, 255, 0.2);
      backdrop-filter: blur(8px);
      -webkit-backdrop-filter: blur(8px);
      border-radius: 10px;
      border: 1px solid rgba(255, 255, 255, 0.3);
      box-shadow: 
        0 8px 32px rgba(0, 0, 0, 0.8),
        inset 0 1px 0 rgba(255, 255, 255, 0.5),
        inset 0 -1px 0 rgba(255, 255, 255, 0.8),
        inset 0 0 6px 3px rgba(255, 255, 255, 0.8);
      position: relative;
      overflow-x: hidden;
    }
    
    .glass-card::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      height: 1px;
      background: linear-gradient(
        90deg,
        transparent,
        rgba(255, 255, 255, 0.8),
        transparent
      );
    }
    
    .glass-card::after {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      width: 1px;
      height: 100%;
      background: linear-gradient(
        180deg,
        rgba(255, 255, 255, 0.8),
        transparent,
        rgba(255, 255, 255, 0.3)
      );
    }
</style>

    <!-- / Content -->

    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->

    <script src="<?php  echo base_url();?>assets/admin/main/vendor/libs/jquery/jquery.js"></script>
    <script src="<?php  echo base_url();?>assets/admin/main/vendor/libs/popper/popper.js"></script>
    <script src="<?php  echo base_url();?>assets/admin/main/vendor/js/bootstrap.js"></script>
    <script src="<?php  echo base_url();?>assets/admin/main/vendor/libs/node-waves/node-waves.js"></script>
    <script src="<?php  echo base_url();?>assets/admin/main/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="<?php  echo base_url();?>assets/admin/main/vendor/libs/hammer/hammer.js"></script>
    <script src="<?php  echo base_url();?>assets/admin/main/vendor/libs/i18n/i18n.js"></script>
    <script src="<?php  echo base_url();?>assets/admin/main/vendor/libs/typeahead-js/typeahead.js"></script>
    <script src="<?php  echo base_url();?>assets/admin/main/vendor/js/menu.js"></script>

    <!-- endbuild -->

    <!-- Vendors JS -->
    <script src="<?php  echo base_url();?>assets/admin/main/vendor/libs/@form-validation/umd/bundle/popular.min.js"></script>
    <script src="<?php  echo base_url();?>assets/admin/main/vendor/libs/@form-validation/umd/plugin-bootstrap5/index.min.js"></script>
    <script src="<?php  echo base_url();?>assets/admin/main/vendor/libs/@form-validation/umd/plugin-auto-focus/index.min.js"></script>

    <!-- Main JS -->
    <script src="<?php  echo base_url();?>assets/admin/main/js/main.js"></script>

    <!-- Page JS -->
    <script src="<?php  echo base_url();?>assets/admin/main/js/pages-auth.js"></script>
  </body>
</html>

<script>
$(document).ready(function () {
    $('#saveBtn').on('click', function () {
        let isValid = true;
        let firstInvalidField = null;
    
        // Validate required fields (one by one)
        $('#inputform [required]').each(function () {
            let value = $(this).val();
            if (Array.isArray(value)) {
                value = value.join('');
            }
            value = value ? value.toString().trim() : '';
    
            if (value === '') {
                isValid = false;
                $(this).addClass('is-invalid').removeClass('is-valid');
                if (!firstInvalidField) {
                    firstInvalidField = this;
                    showToast('Error', `${$(this).attr('placeholder')} is required`, 'error');
                }
            } else {
                $(this).removeClass('is-invalid').addClass('is-valid');
            }
        });
    
        // Stop further validation if required fields failed
        if (!isValid) {
            $('html, body').animate({
                scrollTop: $(firstInvalidField).offset().top - 100
            }, 500);
            return;
        }
        
        // Name Validation (should not start with special character)
        const nameField = $('input[name="name"]');
        const name = nameField.val().trim();
        const namePattern = /^[A-Za-z0-9]/;
        
        if (!namePattern.test(name)) {
            isValid = false;
            nameField.addClass('is-invalid').removeClass('is-valid');
            showToast('Error', 'Name must start with a letter or number (no special characters at the beginning)', 'error');
            $('html, body').animate({ scrollTop: nameField.offset().top - 100 }, 500);
            return;
        } else {
            nameField.removeClass('is-invalid').addClass('is-valid');
        }

        // Mobile Validation
        const mobileField = $('input[name="mobile"]');
        const mobile = mobileField.val().trim();
        const mobilePattern = /^[6-9][0-9]{9}$/;
    
        if (!mobilePattern.test(mobile)) {
            isValid = false;
            mobileField.addClass('is-invalid').removeClass('is-valid');
            showToast('Error', 'Please enter a valid 10-digit mobile number starting with 6-9', 'error');
            $('html, body').animate({ scrollTop: mobileField.offset().top - 100 }, 500);
            return;
        } else {
            mobileField.removeClass('is-invalid').addClass('is-valid');
        }
    
        // Email Validation
        const emailField = $('input[name="email"]');
        const email = emailField.val().trim();
        const emailPattern = /^[A-Za-z0-9][^\s@]*@[^\s@]+\.[^\s@]+$/;
    
        if (!emailPattern.test(email)) {
            isValid = false;
            emailField.addClass('is-invalid').removeClass('is-valid');
            showToast('Error', 'Please enter a valid email address (first character must be a letter or number)', 'error');
            $('html, body').animate({ scrollTop: emailField.offset().top - 100 }, 500);
            return;
        } else {
            emailField.removeClass('is-invalid').addClass('is-valid');
        }
        
        // Latitude Validation (must be decimal, can be negative)
        const latField = $('#latitude');
        const latitude = latField.val().trim();
        const latPattern = /^-?\d+\.\d+$/;
        
        if (!latPattern.test(latitude)) {
            isValid = false;
            latField.addClass('is-invalid').removeClass('is-valid');
            showToast('Error', 'Latitude must be a decimal number (e.g., 12.345 or -45.67)', 'error');
            $('html, body').animate({ scrollTop: latField.offset().top - 100 }, 500);
            return;
        } else {
            latField.removeClass('is-invalid').addClass('is-valid');
        }
        
        // Longitude Validation (must be decimal, can be negative)
        const lonField = $('#longitude');
        const longitude = lonField.val().trim();
        const lonPattern = /^-?\d+\.\d+$/;
        
        if (!lonPattern.test(longitude)) {
            isValid = false;
            lonField.addClass('is-invalid').removeClass('is-valid');
            showToast('Error', 'Longitude must be a decimal number (e.g., 78.123 or -90.456)', 'error');
            $('html, body').animate({ scrollTop: lonField.offset().top - 100 }, 500);
            return;
        } else {
            lonField.removeClass('is-invalid').addClass('is-valid');
        }
        
        // Description Validation (minimum 3 characters)
        const descField = $('#description');
        const description = descField.val().trim();
        
        if (description.length < 3) {
            isValid = false;
            descField.addClass('is-invalid').removeClass('is-valid');
            showToast('Error', 'Description must be at least 3 characters', 'error');
            $('html, body').animate({ scrollTop: descField.offset().top - 100 }, 500);
            return;
        } else {
            descField.removeClass('is-invalid').addClass('is-valid');
        }

    
        // Submit Form via AJAX
        const form = $('#inputform')[0];
        const formData = new FormData(form);
    
        $.ajax({
            url: '<?= base_url("register/sign_up"); ?>',
            type: 'POST',
            data: formData,
            contentType: false,
            processData: false,
            success: function (response) {
                const res = JSON.parse(response);
                if (res.success) {
                    showToast('Success', res.message, 'success');
                    window.location.href = '<?= base_url("admin/login") ?>';
                } else {
                    showToast('Error', res.message, 'error');
                }
            },
            error: function () {
                showToast('Error', 'An unexpected error occurred.', 'error');
            }
        });
    });


    // Remove validation feedback on input/change
    $('#inputform .form-control').on('input change', function () {
        if ($(this).val().trim() !== '') {
            $(this).removeClass('is-invalid').addClass('is-valid');
        } else {
            $(this).removeClass('is-valid').addClass('is-invalid');
        }
    });
});
</script>

<!-- Toastr CSS -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
<!-- Toastr JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>


<script>
// Show toast using jQuery
function showToast(title, message, type) {
    toastr.options = {
        closeButton: true,
        progressBar: true,
        positionClass: "toast-top-right",
        timeOut: "3000",
    };

    if (type === 'success') {
        toastr.success(message, title);
    } else if (type === 'error') {
        toastr.error(message, title);
    } else if (type === 'info') {
        toastr.info(message, title);
    } else if (type === 'warning') {
        toastr.warning(message, title);
    }
}


</script>

<script>
    function get_specialities(cat_id) {
        $.ajax({
            url: '<?= base_url("register/get_specialities/"); ?>' + cat_id,
            type: 'POST',
            dataType: 'json',
            success: function (res) {
                if (res.success) {
                    $('#speciality_id').html(res.data); // will be blank if no specialities
                }
            },
            error: function () {
                showToast('Error', 'An unexpected error occurred.', 'error');
            }
        });
    }

</script>

<script>
  function generateTimeOptions(selectorId) {
    const select = document.getElementById(selectorId);
    const interval = 30; // minutes
    const start = 0; // 12:00 AM
    const end = 23 * 60 + 30; // 11:30 PM

    for (let mins = start; mins <= end; mins += interval) {
      let hours = Math.floor(mins / 60);
      let minutes = mins % 60;

      let ampm = hours >= 12 ? 'PM' : 'AM';
      let displayHour = hours % 12 || 12;
      let displayMin = minutes < 10 ? '0' + minutes : minutes;

      const time = `${displayHour}:${displayMin} ${ampm}`;
      const option = document.createElement('option');
      option.value = time;
      option.text = time;

      select.appendChild(option);
    }
  }

  document.addEventListener('DOMContentLoaded', function () {
    generateTimeOptions('open_time');
    generateTimeOptions('close_time');
  });
</script>

