<style>
    /* Hide default checkbox */
    input[type="checkbox"] {
        appearance: none;
        width: 20px;
        height: 20px;
        border: 2px solid #4CAF50; /* Green border for available */
        border-radius: 5px;
        cursor: pointer;
        position: relative;
    }

    /* Available slot checkbox (Green) */
    input[type="checkbox"]:checked {
        background-color: #4CAF50; /* Green when selected */
    }

    /* Booked slot checkbox (Red, Disabled) */
    input[type="checkbox"].booked {
        background-color: #ff4d4d !important; /* Red */
        border-color: #ff4d4d !important;
        cursor: not-allowed;
    }

    /* Disable hover effect for booked slots */
    input[type="checkbox"].booked:hover {
        opacity: 1;
    }
</style>


<div class="container-xxl flex-grow-1 container-p-y">
              <h4 class="py-3 mb-4"><span class="text-muted fw-light">Edit Doctor Slots</h4>
              
  <div class="row"><div class="col-md-6">
      <div class="card mb-4">
          <form method="post" action="#" id="inputform" enctype="multipart/form-data">
        <div class="card-body">
            
            <div class="mb-3">
            <label for="exampleFormControlInput1" class="form-label">Doctor *</label>
            <select class="form-select" name="doctor_id" required placeholder="Doctor" disabled>
                <option value="">Select Doctor</option>
                <?php if(!empty($doctors)){ 
                foreach($doctors as $row){?>
                <option value="<?=$row['id']?>" <?php if($row['id']==$doctor_id){echo 'selected="selected"';}?>><?=$row['name']?></option>
                <?php } } ?>
            </select>
          </div>
          
          <div class="mb-3">
            <label for="exampleFormControlInput1" class="form-label">Date *</label>
            <input
              type="date"
              class="form-control"
              id="dateInput"
              placeholder="Date" name="date" disabled value="<?=$date?>"/>
          </div>
            
          <?php foreach (['morning', 'afternoon', 'evening'] as $section): ?>
            <?php if (!empty($slots[$section])): ?>
                <div class="mb-3">
                    <strong><?= ucfirst($section) ?></strong><br>
                    <?php foreach ($slots[$section] as $slot): 
                        $slot_time = strtoupper(trim($slot['time']));
                        $is_booked = isset($slot_status[$slot_time]) && $slot_status[$slot_time] === 'booked';
                        $is_checked = in_array($slot_time, $selected_times);
                    ?>
                        <label class="<?= $is_booked ? 'booked' : '' ?>">
                            <input type="checkbox"
                                   class="time-slot <?= $is_booked ? 'booked' : '' ?>"
                                   name="time[]"
                                   value="<?= $slot_time ?>"
                                   <?= $is_checked ? 'checked' : '' ?>
                                   <?= $is_booked ? 'disabled' : '' ?>>
                            <span><?= $slot_time ?></span>
                        </label>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        <?php endforeach; ?>


         
        
        <div class="mb-3">
            <strong>Legend:</strong><br>
            <label>
                <input type="checkbox" disabled style="background-color: #ff4d4d; border-color: #ff4d4d;"> 
                <span>Booked (Cannot Uncheck)</span>
            </label><br>
        
            <label>
                <input type="checkbox" checked disabled style="background-color: #4CAF50; border-color: #4CAF50;"> 
                <span>Previously Selected (Can Uncheck)</span>
            </label><br>
        
            <label>
                <input type="checkbox" disabled style="border: 2px solid #4CAF50;"> 
                <span>Available (Can Select)</span>
            </label>
        </div>
        
        </div>
      </div>
       <!--<button type="button" name="sub" value="sub" class="btn btn-success" id="saveBtn">Submit</button>-->
      </form>
      <a href="<?=base_url('admin/register/doctor_slots')?>"><button type="button" class="btn btn-danger">Cancel</button></a>
    </div></div>
</div>


<script>
$(document).ready(function () {
    $(".time-slot").on("change", function () {
        var id     = "<?= $id ?>";
        var doctor_id = "<?= $doctor_id ?>"; // Get the doctor ID
        var date = "<?= $date ?>"; // Get the selected date
        var time = $(this).val(); // Get the selected time slot
        var isChecked = $(this).prop("checked") ? 1 : 0; // 1 = Add, 0 = Remove

        $.ajax({
            url: "<?= base_url('admin/register/edit_doctor_slot_data') ?>", // Your controller function
            type: "POST",
            data: { doctor_id: doctor_id, date: date, time: time, status: isChecked, id:id},
            success: function (response) {
                const res = JSON.parse(response);
                if (res.success) {
                    showToast('Success', res.message, 'success');
                } else {
                    showToast('Error', res.message, 'error');
                }
            }
        });
    });
});

</script>

<!-- Toastr CSS -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
<!-- Toastr JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>


<script>
// Show toast using jQuery
function showToast(title, message, type) {
    toastr.options = {
        closeButton: true,
        progressBar: true,
        positionClass: "toast-top-right",
        timeOut: "3000",
    };

    if (type === 'success') {
        toastr.success(message, title);
    } else if (type === 'error') {
        toastr.error(message, title);
    } else if (type === 'info') {
        toastr.info(message, title);
    } else if (type === 'warning') {
        toastr.warning(message, title);
    }
}


</script>
            