<style>
    input[type="checkbox"] {
        appearance: none;
        width: 20px;
        height: 20px;
        border: 2px solid #4CAF50;
        border-radius: 5px;
        cursor: pointer;
        position: relative;
    }

    input[type="checkbox"]:checked {
        background-color: #4CAF50;
    }

    input[type="checkbox"].booked {
        background-color: #ff4d4d !important;
        border-color: #ff4d4d !important;
        cursor: pointer;
    }

    input[type="checkbox"].booked:hover {
        opacity: 1;
    }
</style>

<?php
$date = $booking_details[0]['date'];
//$id = $booking_details[0]['id'];

$existing_slots = $this->registermodel->common_fetch('admit_bookings', [
    'id' => $id,
    'date' => $date
]);

$slot_status = [];
foreach ($existing_slots as $slot) {
    $slot_status[$slot['time']] = $slot['booking_status']; // 1 = booked, 0 = available
}
?>

<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="py-3 mb-4"><span class="text-muted fw-light">Edit Admit Slots</span></h4>

    <div class="row">
        <div class="col-md-6">
            <div class="card mb-4">
                <form method="post" action="#" id="inputform" enctype="multipart/form-data">
                    <div class="card-body">

                        <div class="mb-3">
                            <label for="dateInput" class="form-label">Date *</label>
                            <input type="date" class="form-control" id="dateInput" name="date" required value="<?= $booking_details[0]['date'] ?>" />
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Time Slots *</label>

                            <!-- Morning -->
                            <div class="mb-3">
                                <strong>Morning</strong><br>
                                <?php foreach ($slots['morning'] as $morning) {
                                    $is_booked = isset($slot_status[$morning['time']]) && $slot_status[$morning['time']] == "booked";
                                    $checkbox_class = $is_booked ? 'booked' : '';
                                    ?>
                                    <label>
                                        <input type="checkbox" class="time-slot <?= $checkbox_class ?>" name="time[]" value="<?= $morning['time'] ?>"
                                            <?= isset($slot_status[$morning['time']]) ? 'checked' : '' ?>>
                                        <?= $morning['time'] ?>
                                    </label>
                                <?php } ?>
                            </div>

                            <!-- Afternoon -->
                            <div class="mb-3">
                                <strong>Afternoon</strong><br>
                                <?php foreach ($slots['afternoon'] as $afternoon) {
                                    $is_booked = isset($slot_status[$afternoon['time']]) && $slot_status[$afternoon['time']] == "booked";
                                    $checkbox_class = $is_booked ? 'booked' : '';
                                    ?>
                                    <label>
                                        <input type="checkbox" class="time-slot <?= $checkbox_class ?>" name="time[]" value="<?= $afternoon['time'] ?>"
                                            <?= isset($slot_status[$afternoon['time']]) ? 'checked' : '' ?>>
                                        <?= $afternoon['time'] ?>
                                    </label>
                                <?php } ?>
                            </div>

                            <!-- Evening -->
                            <div class="mb-3">
                                <strong>Evening</strong><br>
                                <?php foreach ($slots['evening'] as $evening) {
                                    $is_booked = isset($slot_status[$evening['time']]) && $slot_status[$evening['time']] == "booked";
                                    $checkbox_class = $is_booked ? 'booked' : '';
                                    ?>
                                    <label>
                                        <input type="checkbox" class="time-slot <?= $checkbox_class ?>" name="time[]" value="<?= $evening['time'] ?>"
                                            <?= isset($slot_status[$evening['time']]) ? 'checked' : '' ?>>
                                        <?= $evening['time'] ?>
                                    </label>
                                <?php } ?>
                            </div>
                        </div>

                        <div class="mb-3">
                            <strong>Legend:</strong><br>
                            <label>
                                <input type="checkbox" disabled style="background-color: #ff4d4d; border-color: #ff4d4d;">
                                <span>Booked (Can Select)</span>
                            </label><br>

                            <!--<label>
                                <input type="checkbox" checked disabled style="background-color: #4CAF50; border-color: #4CAF50;">
                                <span>Previously Selected (Can Uncheck)</span>
                            </label><br>-->

                            <label>
                                <input type="checkbox" disabled style="border: 2px solid #4CAF50;">
                                <span>Available (Can Select)</span>
                            </label>
                        </div>
                    </div>
                </form>
            </div>
            <a href="<?= base_url('admin/register/ongoing_admit_bookings') ?>">
                    <button type="button" class="btn btn-danger">Cancel</button>
                </a>
        </div>
    </div>
</div>

<!-- JavaScript -->
<!--<script>-->
<!--    $('#dateInput').on('change', function(){-->
<!--        let selectedDate = $(this).val();-->
    
<!--        $.post('admin/register/get_admitt_slots_by_date', { selected_date: selectedDate }, function(res){-->
<!--            let data = JSON.parse(res);-->
<!--            if(data.status){-->
                <!--// Render slots here-->
<!--                console.log(data.slots);-->
<!--            }-->
<!--        });-->
<!--    });-->
<!--</script>-->
<script>
    document.addEventListener("DOMContentLoaded", function () {
        let today = new Date().toISOString().split('T')[0];
        document.getElementById("dateInput").setAttribute("min", today);
    });

    $(document).ready(function () {
        // Allow only one time slot to be selected at a time
        $(document).on('change', '.time-slot', function () {
            $('.time-slot').not(this).prop('checked', false);
        
            var id = "<?= $id ?>";
            var date = $("#dateInput").val();
            var time = $(this).val();
            var isChecked = $(this).prop("checked") ? 1 : 0;
        
            $.ajax({
                url: "<?= base_url('admin/register/edit_admit_slot_data/' . $id) ?>",
                type: "POST",
                data: { date: date, time: time, status: isChecked, id: id },
                success: function (response) {
                    const res = JSON.parse(response);
                    if (res.success) {
                        showToast('Success', res.message, 'success');
        
                        // Delay refresh for 1.5 seconds so user sees the message
                        setTimeout(function () {
                            location.reload();
                        }, 1500);
                    } else {
                        showToast('Error', res.message, 'error');
                    }
                }
            });
        });


        // Load slots when date changes
        $("#dateInput").on("change", function () {
            var selectedDate = $(this).val();
            var id = "<?= $id ?>";

            $.ajax({
                url: "<?= base_url('admin/register/get_admit_slots_by_date') ?>",
                type: "POST",
                data: { date: selectedDate, id: id },
                success: function (response) {
                    const res = JSON.parse(response);
                
                    if (res.success) {
                        let slotHtml = '';
                
                        const renderSlotGroup = (label, times) => {
                            let html = `<div class="mb-3"><strong>${label}</strong><br>`;
                            times.forEach(time => {
                                const is_booked = res.booked_times.includes(time.time);
                                const checkbox_class = is_booked ? 'booked' : '';
                                const checked = is_booked ? 'checked' : '';
                                html += `
                                    <label>
                                        <input type="checkbox" class="time-slot ${checkbox_class}" name="time[]" value="${time.time}" ${checked}>
                                        ${time.time}
                                    </label>
                                `;
                            });
                            html += '</div>';
                            return html;
                        };
                
                        slotHtml += renderSlotGroup('Morning', res.slots.morning);
                        slotHtml += renderSlotGroup('Afternoon', res.slots.afternoon);
                        slotHtml += renderSlotGroup('Evening', res.slots.evening);
                
                        $('.form-label:contains("Time Slots *")').nextAll().remove(); // Clear old slots
                        $('.form-label:contains("Time Slots *")').after(slotHtml); // Insert new ones
                    }
                }

            });
        });
    });

    function showToast(title, message, type) {
        toastr.options = {
            closeButton: true,
            progressBar: true,
            positionClass: "toast-top-right",
            timeOut: "3000",
        };

        if (type === 'success') {
            toastr.success(message, title);
        } else if (type === 'error') {
            toastr.error(message, title);
        } else if (type === 'info') {
            toastr.info(message, title);
        } else if (type === 'warning') {
            toastr.warning(message, title);
        }
    }
</script>

<!-- Toastr -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
