<div class="container-xxl flex-grow-1 container-p-y">
              <h4 class="py-3 mb-4"><span class="text-muted fw-light">Add Sub Admin</h4>
              
  <div class="row"><div class="col-md-6">
      <div class="card mb-4">
          <form method="post" action="#" id="inputform" enctype="multipart/form-data">
        <div class="card-body">
            
          <div class="mb-3">
            <label for="exampleFormControlInput1" class="form-label">Name *</label>
            <input
              type="text"
              class="form-control"
              id="exampleFormControlInput1"
              placeholder="Name" name="name" required/>
          </div>
          
          <div class="mb-3">
            <label>Mobile *</label>
            <input type="tel" maxlength="10" pattern="[0-9]{10}" required placeholder="Mobile" oninput="this.value = this.value.replace(/[^0-9]/g, '')" placeholder="Mobile" name="mobile" required class="form-control">
        </div>
          
          <div class="mb-3">
            <label for="exampleFormControlInput1" class="form-label">Image *</label>
            <input
              type="file"
              class="form-control"
              id="exampleFormControlInput1"
               name="image" placeholder="Image" required/>
          </div>
          <p style="color:red">please upload only jpg,jpeg and png format files</p>
          
          <div class="mb-3">
              <label class="form-label">Assign Roles *</label>
              <div class="d-flex flex-wrap gap-2">
                <?php foreach ($roles as $role): ?>
                  <div class="form-check">
                    <input class="form-check-input" type="checkbox" name="roles[]" value="<?= $role['id'] ?>" id="role_<?= $role['id'] ?>" required placeholder="Roles">
                    <label class="form-check-label" for="role_<?= $role['id'] ?>">
                      <?= ucfirst($role['name']) ?>
                    </label>
                  </div>
                <?php endforeach; ?>
              </div>
            </div>
          
        </div>
      </div>
       <button type="button" name="sub" value="sub" class="btn btn-success" id="saveBtn">Submit</button>
      </form>
      <a href="<?=base_url('admin/register/sub_admins')?>"><button type="button" class="btn btn-danger">Cancel</button></a>
    </div></div>
</div>



<script>
  $('#saveBtn').on('click', function () {
    let isValid = true;

    // Validate required inputs
    $('#inputform [required]').each(function () {
      let value = $(this).val();
      if (Array.isArray(value)) value = value.join('');
      value = value ? value.toString().trim() : '';
      const fieldName = $(this).attr('name');

      if (value === '') {
        isValid = false;
        $(this).addClass('is-invalid');
        showToast('Error', `${$(this).attr('placeholder')} is required`, 'error');
      } else {
        // Name Validation
        if (fieldName === 'name') {
          const namePattern = /^[A-Za-z][A-Za-z0-9\s\-'.]{2,}$/;
          if (!namePattern.test(value)) {
            isValid = false;
            $(this).addClass('is-invalid');
            showToast('Error', 'Name must start with a letter, be at least 3 characters, and can include letters, numbers, spaces, hyphens (-), apostrophes (\'), or dots (.)', 'error');
            return;
          }
        }

        // Mobile Validation
        if (fieldName === 'mobile') {
          const mobilePattern = /^[6-9][0-9]{9}$/;
          if (!mobilePattern.test(value)) {
            isValid = false;
            $(this).addClass('is-invalid');
            showToast('Error', 'Please enter a valid 10-digit mobile number starting with 6–9.', 'error');
            return;
          }
        }

        // Image Validation
        if (fieldName === 'image') {
          const file = $(this)[0].files[0];
          if (file) {
            const ext = file.name.split('.').pop().toLowerCase();
            if (!['jpg', 'jpeg', 'png'].includes(ext)) {
              isValid = false;
              $(this).addClass('is-invalid');
              showToast('Error', 'Image must be JPG, JPEG or PNG format.', 'error');
              return;
            }
          }
        }

        $(this).removeClass('is-invalid').addClass('is-valid');
      }
    });

    // ✅ At least one role required
    if ($('input[name="roles[]"]:checked').length === 0) {
      isValid = false;
      showToast('Error', 'Please select at least one role.', 'error');
    }

    if (isValid) {
      const form = $('#inputform')[0];
      const formData = new FormData(form);

      $.ajax({
        url: '<?= base_url("admin/register/insert_sub_admin"); ?>',
        type: 'POST',
        data: formData,
        contentType: false,
        processData: false,
        success: function (response) {
          const res = JSON.parse(response);
          if (res.success) {
            showToast('Success', res.message, 'success');
            $('#inputform')[0].reset();
            $('.form-control').removeClass('is-valid');
            window.location.href = '<?= base_url("admin/register/sub_admins") ?>';
          } else {
            showToast('Error', res.message, 'error');
          }
        },
        error: function () {
          showToast('Error', 'An unexpected error occurred.', 'error');
        }
      });
    } else {
      $('html, body').animate({
        scrollTop: $('.is-invalid:first').offset()?.top - 100 || 0
      }, 500);
    }
  });
</script>

<!-- Toastr CSS -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
<!-- Toastr JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>


<script>
// Show toast using jQuery
function showToast(title, message, type) {
    toastr.options = {
        closeButton: true,
        progressBar: true,
        positionClass: "toast-top-right",
        timeOut: "3000",
    };

    if (type === 'success') {
        toastr.success(message, title);
    } else if (type === 'error') {
        toastr.error(message, title);
    } else if (type === 'info') {
        toastr.info(message, title);
    } else if (type === 'warning') {
        toastr.warning(message, title);
    }
}


</script>
            