<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Login extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		date_default_timezone_set("Asia/Kolkata");
		$this->load->library(array('form_validation', 'session'));
		$this->load->helper('url','form','HTML');
		//$this->load->library('Notifications');
		//$this->is_logged_in();
		$this->load->model('admin/loginmodel');
		$this->db->query('SET SESSION sql_mode =
                  REPLACE(REPLACE(REPLACE(
                  @@sql_mode,
                  "ONLY_FULL_GROUP_BY,", ""),
                  ",ONLY_FULL_GROUP_BY", ""),
                  "ONLY_FULL_GROUP_BY", "")'); 
	}
	
/*login*/
public function index(){
	$this->load->view('admin/login');
}
// public function send_otp(){
//     $mobile = $this->input->post('mobile');
//     //$login_type = $this->input->post('login_type');

//     /*if (!preg_match('/^[0-9]{10}$/', $mobile)) {
//         echo json_encode(['success' => false, 'message' => 'Invalid mobile number']);
//         return;
//     }

//     if ($login_type == 'admin') {*/
//         $check_login = $this->loginmodel->common_fetch('admin', ['mobile' => $mobile, 'delete_status' => 1]);
//     /*} elseif ($login_type == 'sub_admin') {
//         $check_login = $this->loginmodel->common_fetch('sub_admins', ['mobile' => $mobile, 'delete_status' => 1]);
//     } else {
//         echo json_encode(['success' => false, 'message' => 'Please select a valid login type']);
//         return;
//     }*/

//     if (empty($check_login)) {
//         echo json_encode(['success' => false, 'message' => 'Mobile number not found']);
//         return;
//     }

//     if ($check_login[0]['status'] == 0) {
//         echo json_encode(['success' => false, 'message' => 'Your account is inactive']);
//         return;
//     }

//     $otp = rand(1000, 9999);
//     $this->session->set_userdata([
//         'otp' => $otp,
//         //'login_type' => $login_type
//     ]);

//     echo json_encode(['success' => true, 'message' => "OTP sent successfully! : $otp"]);
// }
public function send_sms_post($mobile,$get_otp){
    $url = "http://sms.hspsms.com/sendSMS?username=medrayder&message=Dear%20user,%20your%20OTP%20for%20login%20to%20Med%20Rayder%20is%20$get_otp.%20Do%20not%20share%20this%20with%20anyone&sendername=RYDHLT&smstype=TRANS&numbers=$mobile&apikey=70fed238-0847-4a34-b073-264a9f286cca";
    //echo $url;
    $ch = curl_init(); 
    curl_setopt($ch, CURLOPT_URL, $url); 
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    //curl_setopt($ch, CURLOPT_NOBODY, true);
    curl_exec($ch);
    curl_close($ch);
    return true;
}
public function send_otp(){
    $mobile = $this->input->post('mobile');
    $login_type = $this->input->post('login_type');
    
    //echo $mobile;exit;
    
    if (!preg_match('/^[0-9]{10}$/', $mobile)) {
        echo json_encode(['success' => false, 'message' => 'Invalid mobile number']);
        return;
    }

    if ($login_type == 'admin') {
        $check_login = $this->loginmodel->common_fetch('admin', ['mobile' => $mobile, 'delete_status' => 1]);
        //echo $this->db->last_query();exit;
    } elseif ($login_type == 'sub_admin') {
        $check_login = $this->loginmodel->common_fetch('sub_admins', ['mobile' => $mobile, 'delete_status' => 1]);
    }elseif ($login_type == 'tele_caller') {
        $check_login = $this->loginmodel->common_fetch('tele_callers', ['mobile' => $mobile, 'delete_status' => 1]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Please select a valid login type']);
        return;
    }

    if (empty($check_login)) {
        echo json_encode(['success' => false, 'message' => 'Mobile number not found']);
        return;
    }

    if ($check_login[0]['status'] == 0) {
        echo json_encode(['success' => false, 'message' => 'Your account is inactive']);
        return;
    }

    $otp = rand(1000, 9999);
    //$this->send_sms_post($mobile,$otp);
    $this->session->set_userdata([
        'otp' => $otp,
        'login_type' => $login_type
    ]);

    echo json_encode(['success' => true, 'message' => "OTP sent successfully!: $otp"]);
}

// public function check_login(){
//     $otp_session = $this->session->userdata('otp');
//     //$login_type = $this->session->userdata('login_type');
//     $data = [
//         'mobile' => $this->input->post('mobile'),
//         'otp'    => $this->input->post('otp')
//     ];

//     //if ($login_type == 'admin') {
//         $check_login = $this->loginmodel->common_fetch('admin', ['mobile' => $data['mobile'], 'delete_status' => 1]);
//     /*} elseif ($login_type == 'sub_admin') {
//         $check_login = $this->loginmodel->common_fetch('sub_admins', ['mobile' => $data['mobile'], 'delete_status' => 1]);
//     } else {
//         echo json_encode(['success' => false, 'message' => 'Invalid login type.']);
//         return;
//     }*/

//     if (empty($check_login)) {
//         echo json_encode(['success' => false, 'message' => 'Mobile number not found']);
//         return;
//     }

//     if ($check_login[0]['status'] == 0) {
//         echo json_encode(['success' => false, 'message' => 'Your account is inactive']);
//         return;
//     }

//     if ($otp_session != $data['otp']) {
//         echo json_encode(['success' => false, 'message' => 'Incorrect OTP']);
//         return;
//     }

//     // Â­ÐªÐ”Ð° Save role in session for usage in header/menu later
//     $this->session->set_userdata('user_info', [
//         'user_id'      => $check_login[0]['id'],
//         'is_logged_in' => TRUE,
//         'name'         => $check_login[0]['name'],
//         //'role'         => $login_type
//     ]);

//     echo json_encode(['success' => true, 'message' => 'Login successful']);
// }

public function check_login(){
    $otp_session = $this->session->userdata('otp');
    $login_type  = $this->session->userdata('login_type'); // ✅ take from session, not POST
    
    $data = [
        'mobile' => $this->input->post('mobile'),
        'otp'    => $this->input->post('otp')
    ];

    if ($login_type == 'admin') {
        $check_login = $this->loginmodel->common_fetch('admin', ['mobile' => $data['mobile'], 'delete_status' => 1]);
    } elseif ($login_type == 'sub_admin') {
        $check_login = $this->loginmodel->common_fetch('sub_admins', ['mobile' => $data['mobile'], 'delete_status' => 1]);
    } elseif ($login_type == 'tele_caller') {
        $check_login = $this->loginmodel->common_fetch('tele_callers', ['mobile' => $data['mobile'], 'delete_status' => 1]);
        //echo $this->db->last_query();exit;
    }else {
        echo json_encode(['success' => false, 'message' => 'Invalid login type.']);
        return;
    }

    if (empty($check_login)) {
        echo json_encode(['success' => false, 'message' => 'Mobile number not found']);
        return;
    }

    if ($check_login[0]['status'] == 0) {
        echo json_encode(['success' => false, 'message' => 'Your account is inactive']);
        return;
    }

    if ($otp_session != $data['otp']) {
        echo json_encode(['success' => false, 'message' => 'Incorrect OTP']);
        return;
    }

    // ðŸ§  Save role in session for usage in header/menu later
    $this->session->set_userdata('user_info', [
        'user_id'      => $check_login[0]['id'],
        'is_logged_in' => TRUE,
        'name'         => $check_login[0]['name'],
        'login_type'   => $login_type
    ]);

    // ✅ Decide redirect URL
    if ($login_type == 'tele_caller') {
        $redirect_url = base_url("admin/register/tele_caller_index");
    } else {
        $redirect_url = base_url("admin/register");
    }

    echo json_encode([
        'success' => true,
        'message' => 'Login successful',
        'redirect_url' => $redirect_url
    ]);
}


public function logout(){
    $this->session->unset_userdata('user_info');
    $this->session->unset_userdata('otp');
    $this->session->unset_userdata('login_type');
    $this->session->sess_destroy();
    return redirect('admin/login');
}

/*login*/

}
?>