<?php
defined('BASEPATH') OR exit('No direct script access allowed');
//define('KEY','AAAAlwr9C0g:APA91bGDvCkePC2E__03Jm6U3Jz8046DyZN4I-NlwisBhxT0GgpesJ1ZXLvdz5EqeR58Q8f0_Af-tpclYU7X1Eo4FHm34nzXUnrifgLoeFDMtjH77FoxvkHICFWQFt04Az5riiDtIalW');
class Register extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		date_default_timezone_set("Asia/Kolkata");
		$this->load->library(array('form_validation'));
		$this->load->library('session');
		//echo 'hii';exit;
		$this->load->helper('url','form','HTML');

		$this->load->model('admin/registermodel');
		$this->db->query('SET SESSION sql_mode =
                  REPLACE(REPLACE(REPLACE(
                  @@sql_mode,
                  "ONLY_FULL_GROUP_BY,", ""),
                  ",ONLY_FULL_GROUP_BY", ""),
                  "ONLY_FULL_GROUP_BY", "")');
        $this->bharosa_base_path = '/home/medconnectorg/public_html/bharosa/assets/admin/';
	}


/*index*/
public function index(){
    $data['categories'] = $this->registermodel->common_fetch('categories', ['status' => 1, 'delete_status' => 1]);
	$this->load->view('admin/register',$data);
}
public function get_specialities($cat_id){
    $specialities = $this->registermodel->common_fetch('specialities', ['cat_id' => $cat_id, 'status' => 1, 'delete_status' => 1]);


    if (!empty($specialities)) {
        $options = '<option value="" disabled>Select Speciality</option>';
        foreach ($specialities as $speciality) {
            $options .= '<option value="' . $speciality['id'] . '">' . $speciality['name'] . '</option>';
        }
    } else {
        //$options = ''; // return empty string if no data
        
        $options = '<option value="" disabled>No Speciality Found</option>';
    }

    echo json_encode([
        'success' => true,
        'data' => $options
    ]);

}
public function sign_up(){
    $name           = $this->input->post('name');
    $mobile         = $this->input->post('mobile');
    $email          = $this->input->post('email');
    $cat_id         = $this->input->post('cat_id');
    $open_time      = $this->input->post('open_time');
    $close_time     = $this->input->post('close_time');
    $location       = $this->input->post('location');
    $lat            = $this->input->post('lat');
    $lon            = $this->input->post('lon');
    $pharmacy       = $this->input->post('pharmacy');
    $diagnostic     = $this->input->post('diagnostic');
    $description    = $this->input->post('description');
    $speciality_id  = $this->input->post('speciality_id');
    $home_delivery  = $this->input->post('home_delivery');

    $fetch1 = $this->registermodel->common_fetch('main_data', ['mobile' => $mobile, 'delete_status' => 1]);
    if (!empty($fetch1)) {
        echo json_encode(['success' => false, 'message' => 'mobile is registered already']);
        return;
    }

    $fetch2 = $this->registermodel->common_fetch('main_data', ['email' => $email, 'delete_status' => 1]);
    if (!empty($fetch2)) {
        echo json_encode(['success' => false, 'message' => 'email is registered already']);
        return;
    }

    $photo = ''; // Default to null

    if (!empty($_FILES['logo']['name'])) {
        $config['upload_path']      = $this->bharosa_base_path . 'logos/';
        $config['allowed_types']    = 'jpeg|jpg|png';
        $config['file_name']        = time();

        $this->load->library('upload', $config);
        $this->upload->initialize($config, true);

        if (!$this->upload->do_upload('logo')) {
            // File upload failed
            $error = $this->upload->display_errors();
            echo json_encode(['success' => false, 'message' => 'File upload error: ' . $error]);
            return;
        }

        // File upload success
        $uploadData = $this->upload->data();
        $photo = 'assets/admin/logos/' . $uploadData['file_name'];
    }

    $tagline = $this->registermodel->common_fetch('categories', ['id' => $cat_id]);

    $data = [
        'name'              => trim($name),
        'mobile'            => $mobile,
        'email'             => $email,
        'logo'              => $photo,
        'cat_id'            => $cat_id,
        'tagline'           => $tagline[0]['name'],
        'open_time'         => $open_time,
        'close_time'        => $close_time,
        'location'          => $location,
        'lat'               => $lat,
        'lon'               => $lon,
        'pharmacy'          => $pharmacy,
        'diagnostic'        => $diagnostic,
        'description'       => $description,
        'home_delivery'     => $home_delivery,
        'created_on'        => date('Y-m-d H:i:s')
    ];

    $insert = $this->registermodel->common_insert('main_data', $data);

    $exp = explode(',', $speciality_id);
    foreach ($exp as $row) {
        if (!empty($row)) {
            $data1 = [
                'main_data_id'   => $insert,
                'speciality_id'  => $row,
                'created_on'     => date('Y-m-d H:i:s')
            ];
            $this->registermodel->common_insert('main_data_specialities', $data1);
        }
    }

    echo json_encode(['success' => true, 'message' => 'hospital registered successfully']);
    return;
}
/*index*/

}


?>